/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.plugins.spellcheck.context;

import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.SpellCheckingProblemInfo;

public class SpellcheckWordInfo {
    private Position startPosition;
    private Position endPosition;
    private String languageIsoName;
    private String word;

    public void setStartPosition(Position startPosition) {
        this.startPosition = startPosition;
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public void setEndPosition(Position endPosition) {
        this.endPosition = endPosition;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public void setLanguageIsoName(String languageIsoName) {
        this.languageIsoName = languageIsoName;
    }

    public String getLanguageIsoName() {
        return this.languageIsoName;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String getWord() {
        return this.word;
    }

    public static SpellcheckWordInfo from(SpellCheckingProblemInfo problem, AuthorDocumentController controller) throws BadLocationException {
        SpellcheckWordInfo wordInfo = new SpellcheckWordInfo();
        wordInfo.setStartPosition(controller.createPositionInContent(problem.getStartOffset()));
        wordInfo.setEndPosition(controller.createPositionInContent(problem.getEndOffset()));
        wordInfo.setWord(problem.getWord());
        wordInfo.setLanguageIsoName(problem.getLanguageIsoName());
        return wordInfo;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof SpellcheckWordInfo) {
            SpellcheckWordInfo wordInfo = (SpellcheckWordInfo)obj;
            equals = wordInfo.getStartPosition().getOffset() == this.getStartPosition().getOffset() && wordInfo.getEndPosition().getOffset() == this.getEndPosition().getOffset() && wordInfo.getWord().equals(this.getWord()) && wordInfo.getLanguageIsoName().equals(this.getLanguageIsoName());
        }
        return equals;
    }

    public int hashCode() {
        return Objects.hash(this.word, this.languageIsoName, this.startPosition, this.endPosition);
    }
}

