/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.plugins.spellcheck.context;

import com.oxygenxml.webapp.plugins.spellcheck.context.SpellcheckWordInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.SpellCheckingProblemInfo;

public class SpellcheckContext {
    public static final String SPELLCHECK_CONTEXT_ATTR_NAME = "com.oxygenxml.plugins.spellcheck.context";
    private SpellcheckWordInfo currentWordInfo;
    private List<SpellcheckWordInfo> ignoredWords = new ArrayList<SpellcheckWordInfo>();
    private static Comparator<SpellcheckWordInfo> ignoredWordsStartPositionsComparator = (w1, w2) -> {
        Position w2StartPos;
        int cResult = 0;
        Position w1StartPos = w1.getStartPosition();
        if (!w1StartPos.equals(w2StartPos = w2.getStartPosition())) {
            cResult = w1StartPos.getOffset() - w2StartPos.getOffset();
        }
        return cResult;
    };

    public void setCurrentWordInfo(SpellcheckWordInfo wordInfo) {
        this.currentWordInfo = wordInfo;
    }

    public SpellcheckWordInfo getCurrentWord() {
        return this.currentWordInfo;
    }

    public void ignoreCurrentWord() {
        SpellcheckWordInfo currentWord = this.getCurrentWord();
        int index = Collections.binarySearch(this.ignoredWords, currentWord, ignoredWordsStartPositionsComparator);
        if (index < 0) {
            int insertionPoint = -index - 1;
            this.ignoredWords.add(insertionPoint, currentWord);
        } else {
            this.ignoredWords.remove(index);
            this.ignoredWords.add(index, currentWord);
        }
    }

    public List<SpellcheckWordInfo> getIgnoredWords() {
        return this.ignoredWords;
    }

    public boolean isIgnored(SpellCheckingProblemInfo problem, AuthorDocumentController controller) throws BadLocationException {
        SpellcheckWordInfo matchingWord;
        SpellcheckWordInfo wordInfo;
        int index;
        boolean ignored = false;
        if (!this.ignoredWords.isEmpty() && (index = Collections.binarySearch(this.ignoredWords, wordInfo = SpellcheckWordInfo.from(problem, controller), ignoredWordsStartPositionsComparator)) >= 0 && !(ignored = (matchingWord = this.ignoredWords.get(index)).equals(wordInfo))) {
            this.ignoredWords.remove(index);
        }
        return ignored;
    }
}

