/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.plugins.spellcheck;

import com.google.common.base.MoreObjects;
import com.oxygenxml.webapp.plugins.spellcheck.IgnoredWords;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.SpellCheckingProblemInfo;
import ro.sync.ecss.extensions.api.webapp.WebappSpellchecker;
import ro.sync.exml.workspace.api.util.TextChunkDescriptor;

public class SpellcheckPerformer {
    private static final Logger log = LoggerFactory.getLogger(SpellcheckPerformer.class);
    private WebappSpellchecker spellchecker;
    private int docLength;
    private IgnoredWords ignoredWords;

    public SpellcheckPerformer(WebappSpellchecker spellchecker, IgnoredWords ignoredWords, int docLength) {
        this.spellchecker = spellchecker;
        this.ignoredWords = ignoredWords;
        this.docLength = docLength;
    }

    public Optional<SpellCheckingProblemInfo> runSpellcheck(int startOffset, int endOffset, AuthorDocumentController controller) throws AuthorOperationException {
        log.debug("Checking between " + startOffset + " " + endOffset);
        int interval = 1000;
        int currentOffset = startOffset;
        while (currentOffset < endOffset) {
            int intervalEnd = Math.min(currentOffset + interval, endOffset);
            Optional<SpellCheckingProblemInfo> nextProblem = this.runSpellcheckSingleInterval(currentOffset, intervalEnd, controller);
            if (nextProblem.isPresent()) {
                log.debug("Found: " + nextProblem.get().getWord());
                return nextProblem;
            }
            currentOffset = Math.min(currentOffset + interval, endOffset);
        }
        return Optional.empty();
    }

    private Optional<SpellCheckingProblemInfo> runSpellcheckSingleInterval(int start, int end, AuthorDocumentController controller) throws AuthorOperationException {
        log.debug("Checking interval between " + start + " " + end);
        int boundary = 50;
        List textDescriptors = this.spellchecker.getTextDescriptors(Math.max(0, start - boundary), Math.min(this.docLength, end + boundary));
        for (TextChunkDescriptor textDescriptor : textDescriptors) {
            try {
                List<SpellCheckingProblemInfo> problems = this.runSpellcheckTextDescriptor(textDescriptor);
                for (SpellCheckingProblemInfo problem : problems) {
                    if (problem.getStartOffset() < start || problem.getStartOffset() > end || this.ignoredWords.isIgnored(problem, controller)) continue;
                    return Optional.of(problem);
                }
            }
            catch (IOException | BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private List<SpellCheckingProblemInfo> runSpellcheckTextDescriptor(TextChunkDescriptor textDescriptor) throws IOException {
        List problems = this.spellchecker.check(Collections.singletonList(textDescriptor));
        return (List)MoreObjects.firstNonNull((Object)problems, Collections.emptyList());
    }
}

