/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.plugins.spellcheck;

import com.oxygenxml.webapp.plugins.spellcheck.GoToNextSpellingErrorOperation;
import com.oxygenxml.webapp.plugins.spellcheck.context.SpellcheckContext;
import com.oxygenxml.webapp.plugins.spellcheck.context.SpellcheckWordInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.findreplace.WebappFindOptions;

@WebappRestSafe
public class ReplaceAndFindNextSpellingOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(ReplaceAndFindNextSpellingOperation.class);
    private static final String REPLACE_ALL_ARGUMENT_NAME = "replaceAll";
    private static final String NEW_WORD_ARGUMENT_NAME = "newWord";
    public static final String IGNORED_WORDS_ARGUMENT_NAME = "ignoredWords";
    private static final String WORD_CHANGED_RESPONSE = "{\"wordChanged\" :true}";

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        String newWord = (String)args.getArgumentValue(NEW_WORD_ARGUMENT_NAME);
        EditingSessionContext editingContext = model.getAuthorAccess().getEditorAccess().getEditingContext();
        SpellcheckContext spellcheckContext = (SpellcheckContext)editingContext.getAttribute("com.oxygenxml.plugins.spellcheck.context");
        SpellcheckWordInfo currentWordInfo = spellcheckContext.getCurrentWord();
        if (this.isReplaceAll(args)) {
            this.replaceAll(model, currentWordInfo.getWord(), newWord);
        } else {
            Position startPosition = currentWordInfo.getStartPosition();
            Position endPosition = currentWordInfo.getEndPosition();
            String oldWord = this.getOldWord(model, startPosition, endPosition);
            if (!currentWordInfo.getWord().equals(oldWord)) {
                return WORD_CHANGED_RESPONSE;
            }
            this.replace(model, newWord, startPosition, endPosition);
        }
        return new GoToNextSpellingErrorOperation().doOperation(model, args);
    }

    private String getOldWord(AuthorDocumentModel model, Position startPosition, Position endPosition) {
        String oldWord = null;
        try {
            Segment chars = new Segment();
            model.getAuthorDocumentController().getChars(startPosition.getOffset(), endPosition.getOffset() - startPosition.getOffset() + 1, chars);
            oldWord = chars.toString();
        }
        catch (BadLocationException e) {
            log.error((Throwable)e);
        }
        return oldWord;
    }

    private boolean isReplaceAll(ArgumentsMap args) {
        boolean replaceAll = false;
        Object replaceAllArg = args.getArgumentValue(REPLACE_ALL_ARGUMENT_NAME);
        if (replaceAllArg instanceof Boolean) {
            replaceAll = (Boolean)replaceAllArg;
        }
        return replaceAll;
    }

    private void replace(AuthorDocumentModel model, String newWord, Position startPosition, Position endPosition) {
        int startOffset = startPosition.getOffset();
        int endOffset = endPosition.getOffset();
        model.getAuthorDocumentController().delete(startOffset, endOffset);
        model.getAuthorDocumentController().insertText(startOffset, newWord);
        model.getSelectionModel().moveTo(startOffset + newWord.length());
    }

    private void replaceAll(AuthorDocumentModel model, String oldWord, String newWord) {
        WebappFindOptions options = new WebappFindOptions();
        options.setMatchCase(true);
        options.setWholeWords(true);
        model.getFindReplaceSupport().replaceAll(oldWord, newWord, options);
    }
}

