/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.plugins.spellcheck;

import com.oxygenxml.webapp.plugins.spellcheck.context.SpellcheckContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.SpellCheckingProblemInfo;

public class IgnoredWords {
    private final Map<String, List<?>> ingoredWordsTyped = new HashMap();
    private SpellcheckContext spellcheckContext;

    private IgnoredWords(SpellcheckContext spellcheckContext) {
        this.spellcheckContext = spellcheckContext;
    }

    public boolean isIgnored(SpellCheckingProblemInfo problem, AuthorDocumentController controller) throws BadLocationException {
        String canonicalLang = IgnoredWords.getCanonicalLanguage(problem.getLanguageIsoName());
        List ignoredWordsForLang = this.ingoredWordsTyped.getOrDefault(canonicalLang, Collections.emptyList());
        return ignoredWordsForLang.contains(problem.getWord()) || this.spellcheckContext.isIgnored(problem, controller);
    }

    public static IgnoredWords fromUncheckedArgument(Object ignoredWordsArg, SpellcheckContext spellcheckContext) {
        IgnoredWords ignoredWordsObj = new IgnoredWords(spellcheckContext);
        try {
            Map ignoredWordsUntyped = (Map)ignoredWordsArg;
            for (Map.Entry entry : ignoredWordsUntyped.entrySet()) {
                String lang = (String)entry.getKey();
                String canonicalLang = IgnoredWords.getCanonicalLanguage(lang);
                ignoredWordsObj.ingoredWordsTyped.put(canonicalLang, (List)entry.getValue());
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("ingoredWords", e);
        }
        return ignoredWordsObj;
    }

    private static String getCanonicalLanguage(String lang) {
        return lang.substring(0, 2);
    }
}

