/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.plugins.spellcheck;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.oxygenxml.webapp.plugins.spellcheck.IgnoredWords;
import com.oxygenxml.webapp.plugins.spellcheck.SpellcheckPerformer;
import com.oxygenxml.webapp.plugins.spellcheck.context.SpellcheckContext;
import com.oxygenxml.webapp.plugins.spellcheck.context.SpellcheckWordInfo;
import java.io.IOException;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.SpellCheckingProblemInfo;
import ro.sync.ecss.extensions.api.SpellSuggestionsInfo;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.WebappSpellchecker;

@WebappRestSafe
public class GoToNextSpellingErrorOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(GoToNextSpellingErrorOperation.class);

    public String doOperation(AuthorDocumentModel docModel, ArgumentsMap args) throws AuthorOperationException {
        String result = null;
        try {
            EditingSessionContext editingContext = docModel.getAuthorAccess().getEditorAccess().getEditingContext();
            SpellcheckContext spellcheckContext = (SpellcheckContext)editingContext.getAttribute("com.oxygenxml.plugins.spellcheck.context");
            if (spellcheckContext == null) {
                spellcheckContext = new SpellcheckContext();
            }
            IgnoredWords ignoredWords = IgnoredWords.fromUncheckedArgument(args.getArgumentValue("ignoredWords"), spellcheckContext);
            WebappSpellchecker spellchecker = docModel.getSpellchecker();
            Optional<SpellCheckingProblemInfo> maybeNextProblem = this.findNextProblem(docModel, ignoredWords, spellcheckContext);
            if (maybeNextProblem.isPresent()) {
                SpellCheckingProblemInfo nextProblem = maybeNextProblem.get();
                AuthorDocumentController controller = docModel.getAuthorDocumentController();
                spellcheckContext.setCurrentWordInfo(SpellcheckWordInfo.from(nextProblem, controller));
                editingContext.setAttribute("com.oxygenxml.plugins.spellcheck.context", (Object)spellcheckContext);
                docModel.getSelectionModel().setSelection(nextProblem.getStartOffset(), nextProblem.getEndOffset() + 1);
                String[] suggestions = this.findSuggestions(spellchecker, nextProblem);
                result = this.getFindResult(nextProblem, suggestions);
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getFindResult(SpellCheckingProblemInfo nextProblem, String[] suggestions) throws AuthorOperationException {
        String result = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            result = objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"word", (Object)nextProblem.getWord(), (Object)"language", (Object)nextProblem.getLanguageIsoName(), (Object)"startOffset", (Object)nextProblem.getStartOffset(), (Object)"endOffset", (Object)nextProblem.getEndOffset(), (Object)"suggestions", (Object)suggestions));
        }
        catch (IOException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Optional<SpellCheckingProblemInfo> findNextProblem(AuthorDocumentModel docModel, IgnoredWords ignoredWords, SpellcheckContext spellcheckContext) throws AuthorOperationException {
        SpellcheckPerformer spellcheckPerformer;
        Optional<SpellCheckingProblemInfo> problemInfo;
        WebappSpellchecker spellchecker = docModel.getSpellchecker();
        AuthorDocumentController controller = docModel.getAuthorDocumentController();
        AuthorDocument document = controller.getAuthorDocumentNode();
        int startOffset = docModel.getSelectionModel().getCaretOffset();
        SpellcheckWordInfo currentWord = spellcheckContext.getCurrentWord();
        if (currentWord != null) {
            startOffset = currentWord.getEndPosition().getOffset();
        }
        if (!(problemInfo = (spellcheckPerformer = new SpellcheckPerformer(spellchecker, ignoredWords, document.getEndOffset())).runSpellcheck(startOffset, document.getEndOffset(), controller)).isPresent()) {
            problemInfo = spellcheckPerformer.runSpellcheck(0, startOffset, controller);
        }
        return problemInfo;
    }

    private String[] findSuggestions(WebappSpellchecker spellchecker, SpellCheckingProblemInfo nextProblem) throws AuthorOperationException {
        String[] suggestions;
        if (nextProblem.getSuggestions() != null) {
            suggestions = nextProblem.getSuggestions().toArray(new String[0]);
        } else {
            try {
                SpellSuggestionsInfo suggestionInfo = spellchecker.getSuggestionsForWordAtPosition(nextProblem.getStartOffset() + 1);
                suggestions = suggestionInfo.getSuggestions();
            }
            catch (Exception e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return suggestions;
    }
}

