/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NameFormatter;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.relaxng.datatype.Datatype;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IdTypeMapBuilder {
    private boolean hadError;
    private final ErrorHandler eh;
    private final PatternFunction<Integer> idTypeFunction = new IdTypeFunction();
    private final IdTypeMapImpl idTypeMap = new IdTypeMapImpl();
    private final Set<ElementPattern> elementProcessed = new HashSet<ElementPattern>();
    private final Stack<ElementPattern> elementsToProcess = new Stack();
    private final List<PossibleConflict> possibleConflicts = new ArrayList<PossibleConflict>();

    private void notePossibleConflict(NameClass elementNameClass, NameClass attributeNameClass, Locator loc) {
        this.possibleConflicts.add(new PossibleConflict(elementNameClass, attributeNameClass, loc));
    }

    private void error(String key, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key), locator));
            }
            catch (SAXException e) {
                throw new WrappedSAXException(e);
            }
        }
    }

    private void error(String key, Name arg1, Name arg2, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key, NameFormatter.format(arg1), NameFormatter.format(arg2)), locator));
            }
            catch (SAXException e) {
                throw new WrappedSAXException(e);
            }
        }
    }

    public IdTypeMapBuilder(ErrorHandler eh, Pattern pattern) throws SAXException {
        this.eh = eh;
        try {
            pattern.apply(new BuildFunction(null, null));
            while (this.elementsToProcess.size() > 0) {
                ElementPattern p = this.elementsToProcess.pop();
                p.getContent().apply(new BuildFunction(p.getNameClass(), p.getLocator()));
            }
            block3: for (PossibleConflict pc : this.possibleConflicts) {
                if (pc.elementNameClass instanceof SimpleNameClass && pc.attributeNameClass instanceof SimpleNameClass) {
                    Name attributeName;
                    Name elementName = ((SimpleNameClass)pc.elementNameClass).getName();
                    int idType = this.idTypeMap.getIdType(elementName, attributeName = ((SimpleNameClass)pc.attributeNameClass).getName());
                    if (idType == 0) continue;
                    this.error("id_type_conflict", elementName, attributeName, pc.locator);
                    continue;
                }
                for (ScopedName sn : this.idTypeMap.table.keySet()) {
                    if (!pc.elementNameClass.contains(sn.elementName) || !pc.attributeNameClass.contains(sn.attributeName)) continue;
                    this.error("id_type_conflict", sn.elementName, sn.attributeName, pc.locator);
                    continue block3;
                }
            }
        }
        catch (WrappedSAXException e) {
            throw e.cause;
        }
    }

    public IdTypeMap getIdTypeMap() {
        if (this.hadError) {
            return null;
        }
        return this.idTypeMap;
    }

    private static class PossibleConflict {
        private final NameClass elementNameClass;
        private final NameClass attributeNameClass;
        private final Locator locator;

        private PossibleConflict(NameClass elementNameClass, NameClass attributeNameClass, Locator locator) {
            this.elementNameClass = elementNameClass;
            this.attributeNameClass = attributeNameClass;
            this.locator = locator;
        }
    }

    private static class WrappedSAXException
    extends RuntimeException {
        private final SAXException cause;

        WrappedSAXException(SAXException cause) {
            this.cause = cause;
        }
    }

    private class IdTypeFunction
    extends AbstractPatternFunction<Integer> {
        private IdTypeFunction() {
        }

        @Override
        public Integer caseOther(Pattern p) {
            return 0;
        }

        @Override
        public Integer caseData(DataPattern p) {
            return p.getDatatype().getIdType();
        }

        @Override
        public Integer caseDataExcept(DataExceptPattern p) {
            return p.getDatatype().getIdType();
        }

        @Override
        public Integer caseValue(ValuePattern p) {
            return p.getDatatype().getIdType();
        }
    }

    private static class IdTypeMapImpl
    implements IdTypeMap {
        private final Map<ScopedName, Integer> table = new HashMap<ScopedName, Integer>();

        private IdTypeMapImpl() {
        }

        @Override
        public int getIdType(Name elementName, Name attributeName) {
            Integer n = this.table.get(new ScopedName(elementName, attributeName));
            if (n == null) {
                return 0;
            }
            return n;
        }

        private void add(Name elementName, Name attributeName, int idType) {
            this.table.put(new ScopedName(elementName, attributeName), idType);
        }
    }

    private class BuildFunction
    extends AbstractPatternFunction<VoidValue> {
        private final NameClass elementNameClass;
        private final Locator locator;
        private final boolean attributeIsParent;

        BuildFunction(NameClass elementNameClass, Locator locator) {
            this.elementNameClass = elementNameClass;
            this.locator = locator;
            this.attributeIsParent = false;
        }

        BuildFunction(NameClass elementNameClass, Locator locator, boolean attributeIsParent) {
            this.elementNameClass = elementNameClass;
            this.locator = locator;
            this.attributeIsParent = attributeIsParent;
        }

        private BuildFunction down() {
            if (!this.attributeIsParent) {
                return this;
            }
            return new BuildFunction(this.elementNameClass, this.locator, false);
        }

        @Override
        public VoidValue caseChoice(ChoicePattern p) {
            BuildFunction f = this.down();
            p.getOperand1().apply(f);
            p.getOperand2().apply(f);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseInterleave(InterleavePattern p) {
            BuildFunction f = this.down();
            p.getOperand1().apply(f);
            p.getOperand2().apply(f);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseGroup(GroupPattern p) {
            BuildFunction f = this.down();
            p.getOperand1().apply(f);
            p.getOperand2().apply(f);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseOneOrMore(OneOrMorePattern p) {
            p.getOperand().apply(this.down());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseElement(ElementPattern p) {
            if (IdTypeMapBuilder.this.elementProcessed.contains(p)) {
                return VoidValue.VOID;
            }
            IdTypeMapBuilder.this.elementProcessed.add(p);
            IdTypeMapBuilder.this.elementsToProcess.push(p);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern p) {
            int idType = p.getContent().apply(IdTypeMapBuilder.this.idTypeFunction);
            if (idType != 0) {
                NameClass attributeNameClass = p.getNameClass();
                if (!(attributeNameClass instanceof SimpleNameClass)) {
                    IdTypeMapBuilder.this.error("id_attribute_name_class", p.getLocator());
                    return VoidValue.VOID;
                }
                this.elementNameClass.accept(new ElementNameClassVisitor(((SimpleNameClass)attributeNameClass).getName(), this.locator, idType));
            } else {
                IdTypeMapBuilder.this.notePossibleConflict(this.elementNameClass, p.getNameClass(), this.locator);
            }
            p.getContent().apply(new BuildFunction(null, p.getLocator(), true));
            return VoidValue.VOID;
        }

        private void datatype(Datatype dt) {
            if (dt.getIdType() != 0 && !this.attributeIsParent) {
                IdTypeMapBuilder.this.error("id_parent", this.locator);
            }
        }

        @Override
        public VoidValue caseData(DataPattern p) {
            this.datatype(p.getDatatype());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseDataExcept(DataExceptPattern p) {
            this.datatype(p.getDatatype());
            p.getExcept().apply(this.down());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseValue(ValuePattern p) {
            this.datatype(p.getDatatype());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseList(ListPattern p) {
            p.getOperand().apply(this.down());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseOther(Pattern p) {
            return VoidValue.VOID;
        }
    }

    private static class ScopedName {
        private final Name elementName;
        private final Name attributeName;

        private ScopedName(Name elementName, Name attributeName) {
            this.elementName = elementName;
            this.attributeName = attributeName;
        }

        public int hashCode() {
            return this.elementName.hashCode() ^ this.attributeName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScopedName)) {
                return false;
            }
            ScopedName other = (ScopedName)obj;
            return this.elementName.equals(other.elementName) && this.attributeName.equals(other.attributeName);
        }
    }

    private class ElementNameClassVisitor
    implements NameClassVisitor {
        private final Name attributeName;
        private final Locator locator;
        private final int idType;

        ElementNameClassVisitor(Name attributeName, Locator locator, int idType) {
            this.attributeName = attributeName;
            this.locator = locator;
            this.idType = idType;
        }

        @Override
        public void visitChoice(NameClass nc1, NameClass nc2) {
            nc1.accept(this);
            nc2.accept(this);
        }

        @Override
        public void visitName(Name elementName) {
            int tem = IdTypeMapBuilder.this.idTypeMap.getIdType(elementName, this.attributeName);
            if (tem != 0 && tem != this.idType) {
                IdTypeMapBuilder.this.error("id_type_conflict", elementName, this.attributeName, this.locator);
            }
            IdTypeMapBuilder.this.idTypeMap.add(elementName, this.attributeName, this.idType);
        }

        @Override
        public void visitNsName(String ns) {
            this.visitOther();
        }

        @Override
        public void visitNsNameExcept(String ns, NameClass nc) {
            this.visitOther();
        }

        @Override
        public void visitAnyName() {
            this.visitOther();
        }

        @Override
        public void visitAnyNameExcept(NameClass nc) {
            this.visitOther();
        }

        @Override
        public void visitNull() {
        }

        @Override
        public void visitError() {
        }

        private void visitOther() {
            IdTypeMapBuilder.this.error("id_element_name_class", this.locator);
        }
    }
}

