/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.devhelper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.oxygenxml.devhelper.DatadirDetector;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.css.CssInspectorModel;
import ro.sync.ecss.css.CssInspectorResolvedModel;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorHTMLRenderer;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@WebappCompatible
@WebappRestSafe
public class GetCssInspectorModelOperation
extends AuthorOperationWithResult {
    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        CssInspectorModel cssModel = this.doOperationInternal(model);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            return objectMapper.writeValueAsString((Object)cssModel);
        }
        catch (JsonProcessingException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
    }

    CssInspectorModel doOperationInternal(AuthorDocumentModel model) throws AuthorOperationException {
        boolean isTestServerAddon;
        AuthorParentNode elementAtCaret = this.getElementAtCaret(model);
        CssInspectorModel models = ((AuthorHTMLRenderer)model.createRenderer((Writer)new StringWriter())).getResolvedStylesDescriptor(elementAtCaret);
        boolean bl = isTestServerAddon = System.getenv("OXYGEN_INSTALL_DIR_URL") != null;
        if (!isTestServerAddon) {
            this.hideAbsolutePaths(models);
        }
        return models;
    }

    private void hideAbsolutePaths(CssInspectorModel models) {
        CssInspectorResolvedModel resolvedModel = models.getResolvedModel();
        List elementStyles = resolvedModel.getElementStyles();
        this.hideAbsolutePaths(elementStyles);
        List markerStyles = resolvedModel.getMarkerPseudoElementStyles();
        this.hideAbsolutePaths(markerStyles);
        Map beforeStyles = resolvedModel.getBeforePseudoElementStyles();
        for (Map.Entry entry : beforeStyles.entrySet()) {
            this.hideAbsolutePaths((List)entry.getValue());
        }
        Map afterStyles = resolvedModel.getAfterPseudoElementStyles();
        for (Map.Entry entry : afterStyles.entrySet()) {
            this.hideAbsolutePaths((List)entry.getValue());
        }
    }

    private void hideAbsolutePaths(List<CssInspectorResolvedModel.ElementStylesDescriptor> elementStyles) {
        for (CssInspectorResolvedModel.ElementStylesDescriptor elementStyle : elementStyles) {
            for (CssInspectorResolvedModel.RuleDescriptor rule : elementStyle.getRulesDescriptors()) {
                CssInspectorResolvedModel.RuleLocatorDescriptor locator = rule.getLocator();
                locator.setLocation(this.hideAbsolutePath(locator.getLocation()));
            }
        }
    }

    private String hideAbsolutePath(String location) {
        String toReturn;
        block5: {
            toReturn = null;
            if (location.startsWith("file:")) {
                try {
                    URL localFileUrl = new URL(location);
                    File localFile = URLUtil.getFileFromFileUrl((URL)localFileUrl, (boolean)false, (boolean)false, (boolean)false);
                    if (FileSystemUtil.isAncestor((File)DatadirDetector.dataDir, (File)localFile)) {
                        toReturn = URLUtil.makeRelative((URL)DatadirDetector.dataDir.toURI().toURL(), (URL)localFileUrl);
                        break block5;
                    }
                    toReturn = URLUtil.extractFileName((String)location);
                }
                catch (MalformedURLException e) {
                    toReturn = URLUtil.extractFileName((String)location);
                }
            } else {
                toReturn = location.startsWith("jar:") ? this.hideAbsolutePath(location.substring("jar:".length())) : this.hideAbsolutePath(location);
            }
        }
        return toReturn;
    }

    private AuthorParentNode getElementAtCaret(AuthorDocumentModel model) throws AuthorOperationException {
        AuthorNode nodeAtCaret;
        AuthorParentNode elementAtCaret = null;
        try {
            nodeAtCaret = this.getNodeAtCaret(model);
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
        elementAtCaret = nodeAtCaret instanceof AuthorParentNode ? (AuthorParentNode)nodeAtCaret : (AuthorParentNode)nodeAtCaret.getParent();
        return elementAtCaret;
    }

    private AuthorNode getNodeAtCaret(AuthorDocumentModel model) throws BadLocationException {
        AuthorNode nodeAtCaret = null;
        AuthorEditorAccess editorAccess = model.getAuthorAccess().getEditorAccess();
        AuthorNode fullySelectedNode = editorAccess.getFullySelectedNode();
        if (fullySelectedNode != null) {
            nodeAtCaret = fullySelectedNode;
        } else {
            int caretOffset = editorAccess.getCaretOffset();
            nodeAtCaret = model.getAuthorDocumentController().getNodeAtOffset(caretOffset);
        }
        return nodeAtCaret;
    }
}

