/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei.table;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.sort.SimpleTableSortOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class TEITableSortOperation
extends SimpleTableSortOperation {
    @Override
    public boolean isTableElement(AuthorElement node) {
        return "table".equals(node.getLocalName());
    }

    @Override
    public boolean isHeadElement(AuthorElement node) {
        AttrValue roleAttribute = node.getAttribute("role");
        return "row".equals(node.getLocalName()) && roleAttribute != null && "label".equals(roleAttribute.getValue());
    }

    @Override
    public boolean isRowElement(AuthorElement node) {
        return "row".equals(node.getLocalName()) && !this.isHeadElement(node);
    }

    @Override
    public boolean isIgnored(AuthorNode node) {
        boolean isHead = false;
        if (node.getType() == 0) {
            isHead = "head".equals(((AuthorElement)node).getLocalName());
        }
        return isHead || super.isIgnored(node);
    }

    @Override
    protected int getRowIndexForTableBody(AuthorNode table) {
        int index = 0;
        List contentNodes = ((AuthorParentNode)table).getContentNodes();
        for (AuthorNode authorNode : contentNodes) {
            if (authorNode.getType() != 0 || !this.isHeadElement((AuthorElement)authorNode)) continue;
            ++index;
            break;
        }
        return index;
    }
}

