/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.tei.table.ECTEITableCustomizer;
import ro.sync.ecss.extensions.tei.table.SATEITableCustomizer;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertTableOperation
implements AuthorOperation,
InsertTableOperationBase {
    private static final String ARGUMENT_NAME = "defaultNamespace";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("defaultNamespace", 0, "The table namespace"), AbstractTableOperation.TABLE_INFO_ARGUMENT_DESCRIPTOR};
    private static final CommonsOperationsUtil.ConversionElementHelper CONVERSION_ELEMENT_CHECKER = new CommonsOperationsUtil.ConversionElementHelper(){

        @Override
        public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
            AuthorElement element;
            String name;
            boolean canBeConverted = false;
            if (node instanceof AuthorElement && (name = (element = (AuthorElement)node).getLocalName()) != null && ("p".equals(name) || "list".equals(name) || "item".equals(name))) {
                canBeConverted = true;
            }
            if (!canBeConverted) {
                throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("table.convert.exception"));
            }
            return canBeConverted;
        }
    };

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object defaultNamespaceObj = args.getArgumentValue(ARGUMENT_NAME);
        String namespace = null;
        if (defaultNamespaceObj instanceof String) {
            namespace = (String)defaultNamespaceObj;
        }
        AuthorDocumentFragment[] fragments = null;
        ArrayList<Map<String, String>> attributes = null;
        List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFrags = CommonsOperationsUtil.getSelectedFragmentsForConversions(authorAccess, CONVERSION_ELEMENT_CHECKER);
        if (selectedFrags != null) {
            fragments = new AuthorDocumentFragment[selectedFrags.size()];
            attributes = new ArrayList<Map<String, String>>(selectedFrags.size());
            for (int i = 0; i < selectedFrags.size(); ++i) {
                CommonsOperationsUtil.SelectedFragmentInfo currentFrag = selectedFrags.get(i);
                fragments[i] = currentFrag.getSelectedFragment();
                attributes.add(currentFrag.getAttributes());
            }
        }
        Object tableInfoObj = args.getArgumentValue("table_info");
        int minRows = fragments != null ? fragments.length : 0;
        TableInfo tableInfo = tableInfoObj != null ? new TableInfo((Map)tableInfoObj, minRows) : null;
        this.insertTable(fragments, attributes, false, authorAccess, namespace, null, tableInfo);
    }

    private static void addTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, AuthorTableHelper tableHelper, String namespace) throws AuthorOperationException {
        int rows = tableInfo.getRowsNumber();
        int cols = tableInfo.getColumnsNumber();
        for (int i = 0; i < rows; ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<row");
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            for (int j = 0; j < cols; ++j) {
                if (j == 0 && fragments != null) {
                    String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, "cell", i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    continue;
                }
                tableXMLFragment.append("<cell/>");
            }
            tableXMLFragment.append("</row>");
        }
    }

    private static void addTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        tableXMLFragment.append("<row role=\"label\">");
        int cols = tableInfo.getColumnsNumber();
        for (int i = 1; i <= cols; ++i) {
            tableXMLFragment.append("<cell/>");
        }
        tableXMLFragment.append("</row>");
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert a TEI table";
    }

    @Override
    public void insertTable(AuthorDocumentFragment[] fragments, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        this.insertTable(fragments, null, cellsFragments, authorAccess, namespace, tableHelper, tableInfo);
    }

    public void insertTable(AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        StringBuilder tableXMLFragment;
        List<Position> emptyElementsPositions;
        if (tableInfo == null) {
            Platform platform;
            int rowsCount = -1;
            int columnsCount = -1;
            if (fragments != null) {
                rowsCount = fragments.length;
                columnsCount = 1;
            }
            if (Platform.STANDALONE == (platform = authorAccess.getWorkspaceAccess().getPlatform())) {
                tableInfo = SATEITableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount);
            } else if (Platform.ECLIPSE == platform) {
                tableInfo = ECTEITableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount);
            }
        }
        if (tableInfo != null) {
            emptyElementsPositions = CommonsOperationsUtil.removeCurrentSelection(authorAccess);
            tableXMLFragment = new StringBuilder();
            tableXMLFragment.append("<table ");
            if (namespace != null) {
                tableXMLFragment.append("xmlns=\"").append(namespace).append("\" ");
            }
            tableXMLFragment.append("rows=\"").append(tableInfo.getRowsNumber()).append("\" cols=\"").append(tableInfo.getColumnsNumber()).append("\">");
            if (tableInfo.getTitle() != null) {
                tableXMLFragment.append("<head>" + authorAccess.getXMLUtilAccess().escapeTextValue(tableInfo.getTitle()) + "</head>");
            }
            if (tableInfo.isGenerateHeader()) {
                InsertTableOperation.addTableHeader(tableXMLFragment, tableInfo);
            }
        } else {
            throw new AuthorOperationStoppedByUserException("Cancelled by user");
        }
        InsertTableOperation.addTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, authorAccess, tableHelper, namespace);
        tableXMLFragment.append("</table>");
        SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(tableXMLFragment.toString(), authorAccess.getEditorAccess().getCaretOffset());
        TableOperationsUtil.placeCaretInFirstCell(authorAccess, tableInfo, authorAccess.getDocumentController(), result);
        CommonsOperationsUtil.removeEmptyElements(authorAccess, emptyElementsPositions);
    }
}

