/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ReferenceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TEIP5ExternalObjectInsertionHandler
extends AuthorExternalObjectInsertionHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)TEIP5ExternalObjectInsertionHandler.class.getName());

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, List<ReferenceType> types, int source) throws AuthorOperationException {
        if (!urls.isEmpty()) {
            URL base = TEIP5ExternalObjectInsertionHandler.getBaseURLAtCaretPosition((AuthorAccess)authorAccess);
            for (int i = 0; i < urls.size(); ++i) {
                Integer off;
                URL url = urls.get(i);
                ReferenceType type = types.get(i);
                String relativeLocation = authorAccess.getUtilAccess().makeRelative(base, url);
                relativeLocation = authorAccess.getXMLUtilAccess().escapeAttributeValue(relativeLocation);
                SchemaAwareHandlerResult result = null;
                int cp = authorAccess.getEditorAccess().getCaretOffset();
                AuthorElement elementAtOffset = null;
                try {
                    AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(cp);
                    if (nodeAtOffset.getType() == 0) {
                        elementAtOffset = (AuthorElement)nodeAtOffset;
                    }
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (TEIP5ExternalObjectInsertionHandler.isImageReference(authorAccess, type, url)) {
                    if (elementAtOffset != null && "graphic".equals(elementAtOffset.getLocalName())) {
                        authorAccess.getDocumentController().setAttribute("url", new AttrValue(relativeLocation), elementAtOffset);
                    } else {
                        result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<graphic url=\"" + relativeLocation + "\" xmlns=\"http://www.tei-c.org/ns/1.0\"/>", cp, true);
                    }
                } else {
                    result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<ptr target=\"" + relativeLocation + "\" xmlns=\"http://www.tei-c.org/ns/1.0\"/>", cp, true);
                }
                if (result == null || i >= urls.size() - 1 || (off = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) == null) continue;
                authorAccess.getEditorAccess().setCaretPosition(off + 2);
            }
        }
    }

    private static boolean isImageReference(AuthorAccess authorAccess, ReferenceType type, URL url) {
        return type == ReferenceType.IMAGE_REFERENCE || type == null && authorAccess.getUtilAccess().isSupportedImageURL(url);
    }

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, int source) throws AuthorOperationException {
        List<Object> types = Collections.nCopies(urls.size(), null);
        this.insertURLs(authorAccess, urls, types, source);
    }

    protected String getImporterStylesheetFileName(AuthorAccess authorAccess) {
        return "xhtml2tei5Driver.xsl";
    }
}

