/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.operations.InsertListOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class TEIInsertListOperation
extends InsertListOperation {
    static final String ORDERED_LIST = "orderedlist";
    static final String ITEMIZED_LIST = "itemizedlist";
    private static final Logger logger = LoggerFactory.getLogger((String)TEIInsertListOperation.class.getName());
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, new ArgumentDescriptor("listType", 3, "Controls the type of list to be inserted. Accepted values are: orderedlist, itemizedlist. Default value is orderedlist.", new String[]{"orderedlist", "itemizedlist"}, "orderedlist"), CONVERT_ELEMENT_AT_CARET_ARGUMENT_DESCRIPTOR};

    @Override
    protected StringBuilder getListXMLFragment(String listType, Map<String, String> attributes, int numberOfListItems, AuthorAccess authorAccess) {
        boolean orderedList = listType.equals(ORDERED_LIST);
        StringBuilder listXMLFragment = new StringBuilder();
        listXMLFragment.append("<list");
        String namespace = this.getNamespace();
        if (namespace != null) {
            listXMLFragment.append(" xmlns=\"").append(namespace).append("\"");
        }
        if (orderedList) {
            listXMLFragment.append(" type=\"ordered\"");
        } else {
            listXMLFragment.append(" type=\"bulleted\"");
        }
        HashSet<String> attributesToSkip = new HashSet<String>(Arrays.asList("type", "xmlns"));
        listXMLFragment.append(CommonsOperationsUtil.serializeAttributes(attributes, attributesToSkip));
        listXMLFragment.append(">");
        for (int i = 0; i < numberOfListItems; ++i) {
            listXMLFragment.append("<item/>");
        }
        listXMLFragment.append("</list>");
        return listXMLFragment;
    }

    @Override
    protected String getXMLFragment(AuthorAccess authorAccess, String listType, String parentListType) {
        boolean orderedList = listType.equals(ORDERED_LIST);
        StringBuilder listXMLFragment = new StringBuilder();
        String namespace = this.getNamespace();
        if (ORDERED_LIST.equals(parentListType) || ITEMIZED_LIST.equals(parentListType)) {
            listXMLFragment.append("<item");
            if (namespace != null) {
                listXMLFragment.append(" xmlns=\"").append(namespace).append("\"");
            }
            listXMLFragment.append(">");
        }
        listXMLFragment.append("<list");
        if (namespace != null) {
            listXMLFragment.append(" xmlns=\"").append(namespace).append("\"");
        }
        if (orderedList) {
            listXMLFragment.append(" type=\"ordered\"");
        } else {
            listXMLFragment.append(" type=\"bulleted\"");
        }
        listXMLFragment.append("><item/></list>");
        if (ORDERED_LIST.equals(parentListType) || ITEMIZED_LIST.equals(parentListType)) {
            listXMLFragment.append("</item>");
        }
        return listXMLFragment.toString();
    }

    @Override
    protected String getNamespace() {
        return "http://www.tei-c.org/ns/1.0";
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    protected void insertContent(AuthorAccess authorAccess, AuthorNode listNode, List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFragmentsInfos) {
        if (listNode instanceof AuthorElement) {
            List contentNodes = ((AuthorElement)listNode).getContentNodes();
            for (int i = 0; i < contentNodes.size(); ++i) {
                String localName;
                AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                if (!(authorNode instanceof AuthorElement) || !"item".equals(localName = ((AuthorElement)authorNode).getLocalName()) || i >= selectedFragmentsInfos.size()) continue;
                try {
                    String xmlFragment = authorAccess.getDocumentController().serializeFragmentToXML(selectedFragmentsInfos.get(i).getSelectedFragment());
                    Map<String, String> attributes = selectedFragmentsInfos.get(i).getAttributes();
                    if (attributes != null) {
                        Set<String> names = attributes.keySet();
                        for (String attrName : names) {
                            if ("xml:id".equals(attrName)) continue;
                            authorAccess.getDocumentController().setAttribute(attrName, new AttrValue(attributes.get(attrName)), (AuthorElement)authorNode);
                        }
                    }
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment, authorNode.getStartOffset() + 1, 7, false);
                    continue;
                }
                catch (BadLocationException | AuthorOperationException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    public String getDescription() {
        return "Convert the selected paragraph(s) to an ordered/itemized list.";
    }

    @Override
    protected CommonsOperationsUtil.ConversionElementHelper getConversionElementsChecker() {
        return new CommonsOperationsUtil.ConversionElementHelper(){

            @Override
            public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
                AuthorElement element;
                String name;
                boolean canBeConverted = false;
                if (node instanceof AuthorElement && (name = (element = (AuthorElement)node).getLocalName()) != null && ("p".equals(name) || "list".equals(name) || "item".equals(name))) {
                    canBeConverted = true;
                }
                if (!canBeConverted) {
                    throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("list.convert.exception"));
                }
                return canBeConverted;
            }
        };
    }

    @Override
    protected String getParentListType(AuthorNode nodeAtOffset) {
        while (nodeAtOffset != null) {
            if (nodeAtOffset instanceof AuthorElement) {
                AttrValue type;
                String localName = ((AuthorElement)nodeAtOffset).getLocalName();
                if ("item".equals(localName)) {
                    return null;
                }
                if ("list".equals(localName) && (type = ((AuthorElement)nodeAtOffset).getAttribute("type")) != null) {
                    if ("bulleted".equals(type.getValue())) {
                        return ITEMIZED_LIST;
                    }
                    if ("ordered".equals(type.getValue())) {
                        return ORDERED_LIST;
                    }
                }
            }
            nodeAtOffset = nodeAtOffset.getParent();
        }
        return null;
    }

    @Override
    protected boolean isListElement(AuthorNode node) {
        boolean toRet = false;
        if (node instanceof AuthorElement) {
            String localName = ((AuthorElement)node).getLocalName();
            String parentLocalName = ((AuthorElement)node).getParentElement().getLocalName();
            toRet = "list".equals(localName) || "item".equals(localName) || "list".equals(parentLocalName) || "item".equals(parentLocalName);
        }
        return toRet;
    }

    @Override
    protected boolean isList(AuthorNode node) {
        boolean toRet = false;
        if (node instanceof AuthorElement) {
            String localName = ((AuthorElement)node).getLocalName();
            toRet = "list".equals(localName);
        }
        return toRet;
    }

    @Override
    protected String getListTypeDescription(String listType) {
        String toRet = "";
        if (ORDERED_LIST.equals(listType)) {
            toRet = "ordered";
        } else if (ITEMIZED_LIST.equals(listType)) {
            toRet = "itemized";
        }
        return toRet;
    }
}

