/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorImageDecorator;
import ro.sync.ecss.extensions.api.AuthorSchemaAwareEditingHandler;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.EditPropertiesHandler;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.TEIAuthorActionEventHandler;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.spell.SpellCheckerHelper;
import ro.sync.ecss.extensions.commons.table.spansupport.TEITableCellSpanProvider;
import ro.sync.ecss.extensions.tei.EditImageMapOperation;
import ro.sync.ecss.extensions.tei.TEIAuthorImageDecorator;
import ro.sync.ecss.extensions.tei.TEINodeRendererCustomizer;
import ro.sync.ecss.extensions.tei.TEISchemaAwareEditingHandler;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class TEIExtensionsBundleBase
extends ExtensionsBundle {
    private static final Logger logger = LoggerFactory.getLogger((String)TEIExtensionsBundleBase.class.getName());
    private TEISchemaAwareEditingHandler teiSchemaAwareEditingHandler;
    private AuthorActionEventHandler handler;
    private TEIAuthorImageDecorator decorator;

    public AuthorTableCellSpanProvider createAuthorTableCellSpanProvider() {
        return new TEITableCellSpanProvider();
    }

    protected abstract String getDocumentNamespace();

    public AuthorSchemaAwareEditingHandler getAuthorSchemaAwareEditingHandler() {
        if (this.teiSchemaAwareEditingHandler == null) {
            this.teiSchemaAwareEditingHandler = new TEISchemaAwareEditingHandler(this.getDocumentNamespace());
        }
        return this.teiSchemaAwareEditingHandler;
    }

    public XMLNodeRendererCustomizer createXMLNodeCustomizer() {
        return new TEINodeRendererCustomizer();
    }

    public AuthorActionEventHandler getAuthorActionEventHandler() {
        if (this.handler == null) {
            this.handler = new TEIAuthorActionEventHandler();
        }
        return this.handler;
    }

    public AuthorImageDecorator getAuthorImageDecorator() {
        if (this.decorator == null) {
            this.decorator = new TEIAuthorImageDecorator();
        }
        return this.decorator;
    }

    public EditPropertiesHandler createEditPropertiesHandler() {
        return new EditPropertiesHandler(){

            public String getDescription() {
                return "Handles imagemap editing";
            }

            public void editProperties(AuthorNode authorNode, AuthorAccess authorAccess) {
                try {
                    new EditImageMapOperation().doOperation(authorAccess, null);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }

            public boolean canEditProperties(AuthorNode authorNode) {
                boolean isHandled = false;
                if (authorNode.getType() == 0) {
                    AuthorElement parent;
                    AuthorElement element = (AuthorElement)authorNode;
                    if ("surface".equals(element.getLocalName())) {
                        isHandled = true;
                    } else if ("graphic".equals(element.getLocalName()) && (parent = (AuthorElement)element.getParentElement()) != null && "surface".equals(parent.getLocalName())) {
                        isHandled = true;
                    }
                }
                return isHandled;
            }
        };
    }

    public SpellCheckerHelper getSpellCheckerHelper() {
        return new SpellCheckerHelper(){

            public boolean isInlineNodeTransparentForSpellChecking(AuthorNode node) {
                return true;
            }
        };
    }
}

