/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.ImageFileChooser;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertImageOperationP5
implements AuthorOperation {
    public static final String ARGUMENT_IMAGE_URL = "imageUrl";
    public static final String ARGUMENT_WRAP_IN = "wrapIn";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("imageUrl", 0, "The URL of the image. If not defined, an image chooser will be shown."), new ArgumentDescriptor("wrapIn", 0, "The name of the element to wrap the 'graphic' element. If not defined, just the 'graphic' element is inserted.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object imageUrl = args.getArgumentValue(ARGUMENT_IMAGE_URL);
        String ref = null;
        ref = imageUrl instanceof String ? ImageFileChooser.makeUrlRelative(authorAccess, (String)imageUrl) : ImageFileChooser.chooseImageFile(authorAccess);
        if (ref != null) {
            String insert = "<graphic url=\"" + ref + "\" xmlns=\"http://www.tei-c.org/ns/1.0\" />";
            Object wrapIn = args.getArgumentValue(ARGUMENT_WRAP_IN);
            if (wrapIn instanceof String) {
                insert = "<" + wrapIn + " xmlns=\"http://www.tei-c.org/ns/1.0\" >" + insert + "</" + wrapIn + ">";
            }
            authorAccess.getDocumentController().insertXMLFragmentSchemaAware(insert, authorAccess.getEditorAccess().getCaretOffset());
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }

    public String getDescription() {
        return "Insert a TEI P5 image";
    }
}

