/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.SortOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class TEIListSortOperation
extends SortOperation {
    public TEIListSortOperation() {
        super("Selected_items", "All_items");
    }

    @Override
    public AuthorElement getSortParent(int offset, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode selectedNode;
        AuthorElement sortParent = null;
        if (authorAccess.getEditorAccess().hasSelection() && (selectedNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null && selectedNode.getType() == 0 && "list".equals(((AuthorElement)selectedNode).getLocalName())) {
            sortParent = (AuthorElement)selectedNode;
        }
        if (sortParent == null) {
            try {
                AuthorNode nodeAtOffset;
                for (AuthorNode parentNode = nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(offset); parentNode != null && parentNode.getType() != 2; parentNode = parentNode.getParent()) {
                    AuthorElement parentElement;
                    if (parentNode.getType() != 0 || !"list".equals((parentElement = (AuthorElement)parentNode).getLocalName())) continue;
                    sortParent = parentElement;
                    break;
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return sortParent;
    }

    @Override
    public boolean isIgnored(AuthorNode node) {
        return node.getType() == 3 || node.getType() == 5;
    }

    private static void checkValidForSorting(AuthorNode node) throws AuthorOperationException {
        if (!(node instanceof AuthorElement) || !"item".equals(((AuthorElement)node).getLocalName())) {
            throw new AuthorOperationException("The 'Sort' operation is unavailable for lists containing elements which are not 'item'.");
        }
    }

    @Override
    public void canBeSorted(AuthorElement parent, int[] selectedNonIgnoredChildrenInterval) throws AuthorOperationException {
        List<AuthorNode> nonIgnoredChildren = this.getNonIgnoredChildren(parent);
        if (selectedNonIgnoredChildrenInterval == null) {
            selectedNonIgnoredChildrenInterval = new int[]{0, nonIgnoredChildren.size() - 1};
        }
        for (int i = selectedNonIgnoredChildrenInterval[0]; i <= selectedNonIgnoredChildrenInterval[1] && i >= 0 && i < nonIgnoredChildren.size(); ++i) {
            TEIListSortOperation.checkValidForSorting(nonIgnoredChildren.get(i));
        }
    }

    @Override
    public String[] getSortKeysValues(AuthorNode node, SortCriteriaInformation sortInfo) throws AuthorOperationException {
        CriterionInformation[] criterionInfo = sortInfo.criteriaInfo;
        String[] values = null;
        if (node instanceof AuthorElement && criterionInfo.length > 0) {
            values = new String[1];
            AuthorElement authorElement = (AuthorElement)node;
            if ("item".equals(authorElement.getLocalName())) {
                values[0] = this.getTextContentToSort(node);
            }
        }
        return values;
    }

    @Override
    public List<CriterionInformation> getSortCriteria(AuthorElement parent) throws AuthorOperationException {
        ArrayList<CriterionInformation> criteria = new ArrayList<CriterionInformation>();
        int nrChildren = this.getNonIgnoredChildren(parent).size();
        if (nrChildren > 0) {
            criteria.add(new CriterionInformation(0, this.authorAccess.getAuthorResourceBundle().getMessage("List_item")));
        }
        return criteria;
    }

    @Override
    protected String getHelpPageID() {
        return "sort-list-items";
    }
}

