/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dom.wrappers.mutable.AuthorSource;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.exml.workspace.api.util.InternalTransformerAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class XQueryUpdateOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)XQueryUpdateOperation.class.getName());
    public static final String ARGUMENT_SCRIPT = "script";
    public static final String ARGUMENT_SCRIPT_PARAMETERS = "externalParams";
    public static final String ARGUMENT_EXPAND_XINCLUDE_REFERENCES = "expandXincludeReferences";
    private static final String TOKEN_COMMA_END_LINE = ",\n";
    private static final String TOKEN_EQUALS = "=";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[3];
    private Map<String, String> externalArguments = null;

    public XQueryUpdateOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCRIPT, 0, "A path to the script or the script itself.\nWhen using a path the following apply:\n- a relative path is resolved to the framework directory. \n- the ${framework} editor variable can also be used to refer resources from the framework directory. \n- the path is passed through the catalog mappings.\nIf you provide the actual script, the base system ID for this will be the framework file, so any include/import reference will be resolved relative to the \".framework\" file that contains this action definition");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCRIPT_PARAMETERS, 0, "Provide external parameters to the xquery script.\nShould be inserted as name=value pairs separated by comma or line break.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EXPAND_XINCLUDE_REFERENCES, 3, "Add the elements referred through XInclude to the document model.", new String[]{"true", "false"}, "false");
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object script;
        Object paramsArgument = args.getArgumentValue(ARGUMENT_SCRIPT_PARAMETERS);
        if (paramsArgument instanceof String && !((String)paramsArgument).trim().isEmpty()) {
            this.externalArguments = new HashMap<String, String>();
            StringTokenizer commaTokenizer = new StringTokenizer((String)paramsArgument, TOKEN_COMMA_END_LINE);
            while (commaTokenizer.hasMoreElements()) {
                String pair = (String)commaTokenizer.nextElement();
                int indexOfEqual = pair.indexOf(TOKEN_EQUALS);
                if (indexOfEqual != -1) {
                    String param = pair.substring(0, indexOfEqual);
                    String value = pair.substring(indexOfEqual + 1, pair.length());
                    this.externalArguments.put(param.trim(), value);
                    continue;
                }
                throw new IllegalArgumentException("The arguments should be defined as key=value pairs.");
            }
        }
        if ((script = args.getArgumentValue(ARGUMENT_SCRIPT)) instanceof String) {
            StreamSource xQuerySource = null;
            URL url = CommonsOperationsUtil.expandAndResolvePath(authorAccess, (String)script);
            if (url != null) {
                xQuerySource = new StreamSource(url.toExternalForm());
            } else {
                String xq = (String)script;
                if (logger.isDebugEnabled()) {
                    logger.debug("Execute " + xq);
                }
                xQuerySource = new StreamSource(new StringReader(xq));
            }
            AuthorDocumentController documentController = authorAccess.getDocumentController();
            documentController.beginCompoundEdit();
            try {
                Object expandXInclude;
                Transformer queryTransformer = ((InternalTransformerAccess)authorAccess.getXMLUtilAccess()).internalCreateXQueryUpdateTransformer((Source)xQuerySource, null);
                if (this.externalArguments != null) {
                    Set<Map.Entry<String, String>> entrySet = this.externalArguments.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        queryTransformer.setParameter(entry.getKey(), entry.getValue());
                    }
                }
                if ((expandXInclude = args.getArgumentValue(ARGUMENT_EXPAND_XINCLUDE_REFERENCES)) == null) {
                    expandXInclude = false;
                }
                AuthorSource s = new AuthorSource(authorAccess, Boolean.valueOf(expandXInclude.toString()).booleanValue());
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                queryTransformer.transform((Source)s, result);
            }
            catch (IllegalArgumentException | TransformerException e) {
                logger.error((Object)e, (Throwable)e);
                throw new AuthorOperationException("Execution failed: " + e.getMessage(), (Throwable)e);
            }
            finally {
                documentController.endCompoundEdit();
            }
        } else {
            throw new IllegalArgumentException("The argument value was not defined, it is " + script);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Executes an XQuery Update script.";
    }
}

