/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.DeleteElementsOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class DeleteElementOperation
extends DeleteElementsOperation {
    public static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";

    public DeleteElementOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments = new ArgumentDescriptor[1];
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATION, 2, "An XPath expression indicating the element to be deleted.\nNote: If it is not defined, then the element at the caret position will be used.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object xpathLocation = args.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        AuthorNode targetNode = null;
        if (xpathLocation instanceof String) {
            AuthorNode[] results = authorAccess.getDocumentController().findNodesByXPath((String)xpathLocation, true, true, true);
            if (results.length <= 0 || results[0] == null) throw new AuthorOperationException("The element XPath location does not identify a node: " + xpathLocation);
            targetNode = results[0];
        } else {
            try {
                targetNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("Cannot identify the current node", (Throwable)e);
            }
        }
        if (targetNode == null) return;
        authorAccess.getDocumentController().deleteNode(targetNode);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Deletes the element specified by an XPath expression or the element at the caret position";
    }
}

