/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.AuthorXMLUtilAccess;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.xml.parser.SecureXMLReader;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class GenerateIDElementsInfo {
    private static final Logger logger = LoggerFactory.getLogger(GenerateIDElementsInfo.class);
    public static final String GENERATE_ID_ELEMENTS_KEY = "generate.id.for.elements";
    public static final String GENERATE_ID_ELEMENTS_ACTIVE_KEY = "auto.generate.id.elements.active";
    public static final String GENERATE_ID_PATTERN_KEY = "generate.ids.pattern";
    public static final String FILTER_IDS_ON_COPY_KEY = "filter.ids.on.copy";
    public static final String LOCAL_NAME_PATTERN_MACRO = "${localName}";
    public static final String LOCAL_NAME_PATTERN_DESCRIPTION = "The local name of the element.";
    public static final String UUID_PATTERN_DESCRIPTION = "Universally Unique Identifier";
    public static final String ID_PATTERN_DESCRIPTION = "Compact Unique Identifier";
    public static final String DEFAULT_ID_GENERATION_PATTERN = "${localName}_${id}";
    public static final String PATTERN_TOOLTIP = "${id} - Compact Unique Identifier; \n${uuid} - Universally Unique Identifier; \n ${localName} - The local name of the element.";
    private boolean autoGenerateIds;
    private String idGenerationPattern;
    private String[] elementsWithIDGeneration;
    private boolean removeIDsOnCopy;
    private String patternTooltip = "${id} - Compact Unique Identifier; \n${uuid} - Universally Unique Identifier; \n ${localName} - The local name of the element.";
    private String attrQname;

    public GenerateIDElementsInfo(AuthorAccess authorAccess, GenerateIDElementsInfo defaultOptions) {
        this(GenerateIDElementsInfo.isAutoGenerateIDs(authorAccess, defaultOptions), GenerateIDElementsInfo.getIdGenerationPattern(authorAccess, defaultOptions), GenerateIDElementsInfo.getIDGenerationElements(authorAccess, defaultOptions), GenerateIDElementsInfo.isFilterIDs(authorAccess, defaultOptions));
        this.setPatternTooltip(defaultOptions.getPatternTooltip());
    }

    private static String[] getIDGenerationElements(AuthorAccess authorAccess, GenerateIDElementsInfo defaultOptions) {
        String stringOption = defaultOptions.getElementsAsOptionsString();
        if (authorAccess != null) {
            stringOption = authorAccess.getOptionsStorage().getOption(GENERATE_ID_ELEMENTS_KEY, stringOption);
        }
        return GenerateIDElementsInfo.splitStrings(stringOption);
    }

    private static String getIdGenerationPattern(AuthorAccess authorAccess, GenerateIDElementsInfo defaultOptions) {
        String idGenerationPattern = defaultOptions.getIdGenerationPattern();
        if (authorAccess != null) {
            idGenerationPattern = authorAccess.getOptionsStorage().getOption(GENERATE_ID_PATTERN_KEY, idGenerationPattern);
        }
        return idGenerationPattern;
    }

    private static boolean isAutoGenerateIDs(AuthorAccess authorAccess, GenerateIDElementsInfo defaultOptions) {
        Boolean autoGenerate = defaultOptions.isAutoGenerateIDs();
        if (authorAccess != null) {
            autoGenerate = Boolean.valueOf(authorAccess.getOptionsStorage().getOption(GENERATE_ID_ELEMENTS_ACTIVE_KEY, Boolean.toString(defaultOptions.isAutoGenerateIDs())));
        }
        return autoGenerate;
    }

    private static boolean isFilterIDs(AuthorAccess authorAccess, GenerateIDElementsInfo defaultOptions) {
        boolean isFilterIDsOnCopy = defaultOptions.isFilterIDsOnCopy();
        if (authorAccess != null) {
            isFilterIDsOnCopy = Boolean.valueOf(authorAccess.getOptionsStorage().getOption(FILTER_IDS_ON_COPY_KEY, Boolean.toString(isFilterIDsOnCopy)));
        }
        return isFilterIDsOnCopy;
    }

    private static String[] splitStrings(String optionsString) {
        if (optionsString == null || optionsString.trim().length() == 0) {
            return null;
        }
        return optionsString.split(",");
    }

    public GenerateIDElementsInfo(boolean autoGenerateIds, String idGenerationPattern, String[] elementsWithIDGeneration) {
        this(autoGenerateIds, idGenerationPattern, elementsWithIDGeneration, true);
    }

    public GenerateIDElementsInfo(boolean autoGenerateIds, String idGenerationPattern, String[] elementsWithIDGeneration, boolean filterIDsOnCopy) {
        this.autoGenerateIds = autoGenerateIds;
        this.idGenerationPattern = idGenerationPattern;
        this.elementsWithIDGeneration = elementsWithIDGeneration;
        this.removeIDsOnCopy = filterIDsOnCopy;
    }

    public boolean isAutoGenerateIDs() {
        return this.autoGenerateIds;
    }

    public boolean isFilterIDsOnCopy() {
        return this.removeIDsOnCopy;
    }

    public String getIdGenerationPattern() {
        return this.idGenerationPattern;
    }

    public String[] getElementsWithIDGeneration() {
        return this.elementsWithIDGeneration;
    }

    public void saveToOptions(AuthorAccess authorAccess) {
        StringBuilder toSave = new StringBuilder();
        toSave.append(this.getElementsAsOptionsString());
        authorAccess.getOptionsStorage().setOption(GENERATE_ID_ELEMENTS_KEY, toSave.toString());
        authorAccess.getOptionsStorage().setOption(GENERATE_ID_PATTERN_KEY, this.idGenerationPattern);
        authorAccess.getOptionsStorage().setOption(GENERATE_ID_ELEMENTS_ACTIVE_KEY, Boolean.toString(this.autoGenerateIds));
        authorAccess.getOptionsStorage().setOption(FILTER_IDS_ON_COPY_KEY, Boolean.toString(this.removeIDsOnCopy));
    }

    private String getElementsAsOptionsString() {
        StringBuilder toSave = new StringBuilder();
        if (this.elementsWithIDGeneration != null) {
            for (int i = 0; i < this.elementsWithIDGeneration.length; ++i) {
                toSave.append(this.elementsWithIDGeneration[i]).append(",");
            }
        }
        return toSave.toString();
    }

    public static String generateID(String idGenerationPattern, String elementLocalName) {
        return GenerateIDElementsInfo.generateID(idGenerationPattern, elementLocalName, null);
    }

    public static String generateID(String idGenerationPattern, String elementLocalName, String editorLocation) {
        if (idGenerationPattern.indexOf(LOCAL_NAME_PATTERN_MACRO) != -1) {
            idGenerationPattern = GenerateIDElementsInfo.replaceAll(idGenerationPattern, LOCAL_NAME_PATTERN_MACRO, elementLocalName);
        }
        idGenerationPattern = EditorVariables.expandEditorVariables((String)idGenerationPattern, (String)editorLocation);
        return idGenerationPattern;
    }

    private static String replaceAll(String original, String match, String toReplaceWith) {
        try {
            return Pattern.compile(match, 16).matcher(original).replaceAll(Matcher.quoteReplacement(toReplaceWith));
        }
        catch (Throwable t) {
            return original;
        }
    }

    public void setAutoGenerateIds(boolean autoGenerateIds) {
        this.autoGenerateIds = autoGenerateIds;
    }

    public void setElementsWithIDGeneration(String[] elementsWithIDGeneration) {
        this.elementsWithIDGeneration = elementsWithIDGeneration;
    }

    public void setRemoveIDsOnCopy(boolean removeIDsOnCopy) {
        this.removeIDsOnCopy = removeIDsOnCopy;
    }

    public void setIdGenerationPattern(String idGenerationPattern) {
        this.idGenerationPattern = idGenerationPattern;
    }

    public String getPatternTooltip() {
        return this.patternTooltip;
    }

    public void setPatternTooltip(String patternTooltip) {
        this.patternTooltip = patternTooltip;
    }

    public static GenerateIDElementsInfo loadDefaultsFromConfiguration(AuthorAccess authorAccess, String proposedXMLResourceName) {
        AuthorXMLUtilAccess xmlUtilAccess;
        URL optionsLoadURL;
        if (proposedXMLResourceName == null) {
            proposedXMLResourceName = "idGenerationDefaultOptions.xml";
        }
        final GenerateIDElementsInfo loaded = new GenerateIDElementsInfo(false, DEFAULT_ID_GENERATION_PATTERN, new String[0]);
        if (authorAccess != null && (optionsLoadURL = CommonsOperationsUtil.locateResourceInClasspath(authorAccess, proposedXMLResourceName)) != null && (xmlUtilAccess = authorAccess.getXMLUtilAccess()) != null) {
            XMLReader reader = xmlUtilAccess.newNonValidatingXMLReader();
            final ArrayList elems = new ArrayList();
            reader.setContentHandler(new ContentHandler(){
                private StringBuilder chars = new StringBuilder();

                @Override
                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    this.chars.setLength(0);
                }

                @Override
                public void startDocument() throws SAXException {
                }

                @Override
                public void skippedEntity(String name) throws SAXException {
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                }

                @Override
                public void processingInstruction(String target, String data) throws SAXException {
                }

                @Override
                public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                }

                @Override
                public void endPrefixMapping(String prefix) throws SAXException {
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (localName != null) {
                        switch (localName) {
                            case "autoGenerate": {
                                loaded.autoGenerateIds = "true".equals(this.chars.toString().trim());
                                break;
                            }
                            case "idAttribute": {
                                loaded.attrQname = this.chars.toString().trim();
                                break;
                            }
                            case "idPattern": {
                                loaded.idGenerationPattern = this.chars.toString().trim();
                                break;
                            }
                            case "removeIDsOnCopy": {
                                loaded.removeIDsOnCopy = "true".equals(this.chars.toString().trim());
                                break;
                            }
                            case "generateForElement": {
                                elems.add(this.chars.toString().trim());
                            }
                        }
                    }
                    this.chars.setLength(0);
                }

                @Override
                public void endDocument() throws SAXException {
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.chars.append(ch, start, length);
                }
            });
            try {
                SecureXMLReader.parse((XMLReader)reader, (String)optionsLoadURL.toString());
                loaded.elementsWithIDGeneration = elems.toArray(new String[0]);
            }
            catch (IOException | SAXException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return loaded;
    }

    public String getAttrQname() {
        return this.attrQname;
    }
}

