/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.mathml;

import com.oxygenxml.sdksamples.mathml.EditingSessionContextManager;
import com.oxygenxml.sdksamples.mathml.JEuclidRenderer;
import com.oxygenxml.sdksamples.mathml.PerDocumentEquationCache;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.formcontrols.WebappFormControlRenderer;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.util.PrettyPrintException;

public class WebappMathMLRenderer
extends WebappFormControlRenderer {
    private static final Logger log = LoggerFactory.getLogger(WebappMathMLRenderer.class);

    public void renderControl(AuthorInplaceContext context, Writer out) throws IOException {
        AuthorElement mathMlElement = context.getElem();
        AuthorAccess authorAccess = context.getAuthorAccess();
        EditingSessionContextManager.ensureInitialized(authorAccess);
        EditingSessionContext editingContext = authorAccess.getEditorAccess().getEditingContext();
        PerDocumentEquationCache equationCache = (PerDocumentEquationCache)editingContext.getAttribute("com.oxygenxml.sdksamples.mathml.eq_cache");
        String docId = (String)editingContext.getAttribute("com.oxygenxml.sdksamples.mathml.author_access_id");
        try {
            long elemId = equationCache.freezeMathMLfrag(mathMlElement);
            String xml = equationCache.getXmlFragment(elemId);
            String xmlHash = DigestUtils.sha256Hex((String)xml);
            String systemID = authorAccess.getDocumentController().getAuthorDocumentNode().getSystemID();
            String xmlPPed = this.formatAndIndentXmlFragment(xml, systemID);
            BufferedImage image = new JEuclidRenderer().convertToImage(authorAccess, xml);
            String escapedXML = PluginWorkspaceProvider.getPluginWorkspace().getXMLUtilAccess().escapeAttributeValue(xmlPPed);
            out.append(this.generateImgHtml(image, docId, elemId, xmlHash, escapedXML, context.isReadOnlyContext()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            out.append("<span style=\"color: red\">Error rendering MathML</span>");
        }
    }

    public boolean isChangeTrackingAware() {
        return true;
    }

    String generateImgHtml(BufferedImage image, String docId, long elemId, String xmlHash, String escapedXML, boolean readOnly) {
        return "<img width=\"" + image.getWidth() + "\" height=\"" + image.getHeight() + "\" class=\"mathml-image\" src=\"../plugins-dispatcher/mathml?xmlHash=" + xmlHash + ".png&elemId=" + elemId + "&docId=" + docId + "\"" + (readOnly ? " data-ro=\"true\"" : "") + " alt=\"" + escapedXML + "\"></img>";
    }

    String formatAndIndentXmlFragment(String xmlContent, String systemID) {
        String formattedContent = "";
        if (xmlContent != null) {
            formattedContent = xmlContent;
            try {
                formattedContent = PluginWorkspaceProvider.getPluginWorkspace().getXMLUtilAccess().prettyPrint((Reader)new StringReader(xmlContent), systemID);
            }
            catch (PrettyPrintException e1) {
                log.debug("Content not in XML format");
            }
        }
        return formattedContent;
    }

    public String getDescription() {
        return "Math ML Form Control Renderer";
    }
}

