/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.mathml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.swing.text.BadLocationException;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

public class PerDocumentEquationCache {
    private final AuthorDocumentController docController;
    private final Map<Long, String> mathMLElements = new HashMap<Long, String>(0);
    private long lastCompactedCacheSize = 4L;
    Map<AuthorElement, Long> nodeIndexer = new WeakHashMap<AuthorElement, Long>();
    private long counter = 0L;

    public PerDocumentEquationCache(AuthorDocumentController controller) {
        this.docController = controller;
    }

    public synchronized long freezeMathMLfrag(AuthorElement elem) throws BadLocationException {
        long elemId = this.nodeIndexer.computeIfAbsent(elem, new Function<AuthorElement, Long>(){

            @Override
            public Long apply(AuthorElement t) {
                return PerDocumentEquationCache.this.counter++;
            }
        });
        AuthorDocumentFragment mathMlFrag = this.docController.createDocumentFragment((AuthorNode)elem, true);
        String xml = this.docController.serializeFragmentToXML(mathMlFrag);
        this.mathMLElements.put(elemId, xml);
        if ((long)this.mathMLElements.size() > 2L * this.lastCompactedCacheSize) {
            this.compactCache();
        }
        return elemId;
    }

    private void compactCache() {
        HashSet<Long> valuesSet = new HashSet<Long>(this.nodeIndexer.values());
        this.mathMLElements.entrySet().removeIf(entry -> !valuesSet.contains(entry.getKey()));
        this.lastCompactedCacheSize = this.mathMLElements.size();
    }

    int getSize() {
        return this.mathMLElements.size();
    }

    public synchronized String getXmlFragment(long elemId) {
        return this.mathMLElements.get(elemId);
    }
}

