/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.mathml;

import com.google.common.net.MediaType;
import com.oxygenxml.sdksamples.mathml.EditingSessionContextManager;
import com.oxygenxml.sdksamples.mathml.JEuclidRenderer;
import com.oxygenxml.sdksamples.mathml.PerDocumentEquationCache;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;

public class MathmlServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(MathmlServlet.class);

    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        String docId = httpRequest.getParameter("docId");
        String elemId = httpRequest.getParameter("elemId");
        AuthorAccess authorAccess = EditingSessionContextManager.getDocument(docId);
        if (authorAccess != null) {
            BufferedImage image;
            EditingSessionContext editingContext = authorAccess.getEditorAccess().getEditingContext();
            PerDocumentEquationCache equationCache = (PerDocumentEquationCache)editingContext.getAttribute("com.oxygenxml.sdksamples.mathml.eq_cache");
            String xml = equationCache.getXmlFragment(Long.valueOf(elemId));
            try {
                image = new JEuclidRenderer().convertToImage(authorAccess, xml);
            }
            catch (SAXException e) {
                log.error("Error parsing MathML content: " + e.getMessage(), (Throwable)e);
                httpResponse.setHeader("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString());
                httpResponse.sendError(500, "Error parsing MathML content");
                return;
            }
            httpResponse.setHeader("Content-Type", MediaType.PNG.toString());
            httpResponse.setHeader("Cache-Control", "max-age=31536000");
            ImageIO.write((RenderedImage)image, "png", (OutputStream)httpResponse.getOutputStream());
        } else {
            httpResponse.sendError(404, "MathML PNG file was not found.");
        }
    }

    public String getPath() {
        return "mathml";
    }
}

