/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.mathml;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.converter.Converter;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.xml.parser.ParserCreator;

public class JEuclidRenderer {
    private static final String MATH_ML_DOCTYPE = "<!DOCTYPE math PUBLIC \"-//W3C//DTD MathML 2.0//EN\" \"http://www.w3.org/Math/DTD/mathml2/mathml2.dtd\">\n";
    private static final Pattern prefixPattern = Pattern.compile("<([a-z]+):math");
    private static final Pattern namedEntityPattern = Pattern.compile("&[^#]");

    Document loadXMLFromString(String xml, String systemID, AuthorDocumentType docType) throws IOException, SAXException {
        String prefix;
        DOMParser domParser = ParserCreator.createDOMParser();
        domParser.getXMLParserConfiguration().setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        if (this.containsNamedEntities((String)xml)) {
            String docTypeStr = docType != null ? docType.serializeDoctype() : MATH_ML_DOCTYPE;
            xml = docTypeStr + (String)xml;
        } else if (!this.hasNamespacePrefixDeclaration((String)xml) && (prefix = this.detectNamespacePrefix((String)xml)) != null) {
            xml = this.addMathmlNamespacePrefixMapping((String)xml, prefix);
        }
        InputSource inputSource = new InputSource(new StringReader((String)xml));
        inputSource.setSystemId(systemID);
        domParser.parse(inputSource);
        return domParser.getDocument();
    }

    String addMathmlNamespacePrefixMapping(String xml, String prefix) {
        return xml.replaceFirst("<" + prefix + ":math(/|\\s|>)", "<" + prefix + ":math xmlns:" + prefix + "=\"http://www.w3.org/1998/Math/MathML\"$1");
    }

    boolean containsNamedEntities(String xml) {
        Matcher matcher = namedEntityPattern.matcher(xml);
        return matcher.find();
    }

    boolean hasNamespacePrefixDeclaration(String xml) {
        return xml.contains("http://www.w3.org/1998/Math/MathML");
    }

    String detectNamespacePrefix(String xml) {
        Matcher matcher = prefixPattern.matcher(xml);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public BufferedImage convertToImage(AuthorAccess authorAccess, String xml) throws IOException, SAXException {
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        AuthorDocumentType docType = documentController.getDoctype();
        String systemID = documentController.getAuthorDocumentNode().getSystemID();
        Converter converter = Converter.getInstance();
        Document doc = this.loadXMLFromString(xml, systemID, docType);
        return converter.render((Node)doc, (LayoutContext)new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext()));
    }
}

