/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook.table.properties;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.docbook.table.properties.DocbookCALSTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DocbookHTMLTableHelper
extends DocbookCALSTableHelper {
    private static final String CELL_NAME = "td";
    private static final String HEADER_CELL_NAME = "th";
    private static final String ROW_NAME = "tr";
    private static final String HEADER_NAME = "thead";
    private static final String BODY_NAME = "tbody";
    private static final String FOOTER_NAME = "tfoot";

    @Override
    public boolean isTableRow(AuthorElement node) {
        return ROW_NAME.equals(node.getLocalName());
    }

    @Override
    public boolean isTableFoot(AuthorElement element) {
        return FOOTER_NAME.equals(element.getLocalName());
    }

    @Override
    public boolean isTableGroup(AuthorElement element) {
        return "table".equals(element.getLocalName());
    }

    @Override
    public boolean isTableColspec(AuthorElement element) {
        return "col".equals(element.getLocalName());
    }

    @Override
    public boolean isTableCell(AuthorElement element) {
        return CELL_NAME.equals(element.getLocalName()) || HEADER_CELL_NAME.equals(element.getLocalName());
    }

    @Override
    public String getElementTag(int elementType) {
        return "<" + this.getElementName(elementType) + "/>";
    }

    @Override
    public String getElementName(int elementType) {
        String elementName = "";
        switch (elementType) {
            case 1: {
                elementName = BODY_NAME;
                break;
            }
            case 2: {
                elementName = HEADER_NAME;
                break;
            }
            case 3: {
                elementName = FOOTER_NAME;
                break;
            }
            case 0: {
                elementName = ROW_NAME;
                break;
            }
            case 8: {
                elementName = HEADER_CELL_NAME;
                break;
            }
            case 6: {
                elementName = CELL_NAME;
                break;
            }
        }
        return elementName;
    }

    @Override
    public boolean isTable(AuthorElement element) {
        return super.isTable(element) || "informaltable".equals(element.getLocalName());
    }
}

