/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.docbook.table.ECDocbookInnerTableCustomizer;
import ro.sync.ecss.extensions.docbook.table.ECDocbookTableCustomizer;
import ro.sync.ecss.extensions.docbook.table.SADocbookInnerTableCustomizer;
import ro.sync.ecss.extensions.docbook.table.SADocbookTableCustomizer;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class InsertTableOperation
extends AbstractTableOperation
implements InsertTableOperationBase,
InsertTableCellsContentConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InsertTableOperation.class.getName());
    private static final String HTML_TABLE_MODEL = "html";
    private static final String CALS_TABLE_MODEL = "cals";
    private static final String NO_TABLE_MODEL = "none";
    public static final String DEFAULT_TABLE_MODEL_ARGUMENT_NAME = "defaultTableModel";
    public static final ArgumentDescriptor TABLE_MODEL_ARGUMENT = new ArgumentDescriptor("defaultTableModel", 3, "The preferred model of the table that will be inserted.\nCan be: cals, html or none.", new String[]{"cals", "html", "none"}, "none");
    private String cellContent = "";
    private int defaultTableModel = -1;
    private static final CommonsOperationsUtil.ConversionElementHelper CONVERSION_ELEMENT_CHECKER = new CommonsOperationsUtil.ConversionElementHelper(){

        @Override
        public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
            AuthorElement element;
            String name;
            boolean canBeConverted = false;
            if (node instanceof AuthorElement && (name = (element = (AuthorElement)node).getLocalName()) != null) {
                boolean isList;
                boolean bl = isList = "variablelist".equals(name) || "itemizedlist".equals(name) || "orderedlist".equals(name) || "listitem".equals(name) || "varlistentry".equals(name);
                if (isList || "para".equals(name) || "term".equals(name) || "dt".equals(name)) {
                    canBeConverted = true;
                }
            }
            if (!canBeConverted) {
                throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("table.convert.exception"));
            }
            return canBeConverted;
        }
    };
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{NAMESPACE_ARGUMENT_DESCRIPTOR, CELL_FRAGMENT_ARGUMENT, TABLE_MODEL_ARGUMENT, AbstractTableOperation.TABLE_INFO_ARGUMENT_DESCRIPTOR};

    public InsertTableOperation() {
        super(new CALSDocumentTypeHelper());
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object cellFragmentObj = args.getArgumentValue("cellFragment");
        if (cellFragmentObj instanceof String) {
            this.cellContent = (String)cellFragmentObj;
        }
        if (this.cellContent == null) {
            this.cellContent = "";
        }
        Object namespaceObj = args.getArgumentValue("namespace");
        Object tableModelObj = args.getArgumentValue(DEFAULT_TABLE_MODEL_ARGUMENT_NAME);
        if (tableModelObj instanceof String) {
            String tableModelStr = (String)tableModelObj;
            if (CALS_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = 1;
            } else if (HTML_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = 0;
            } else if (NO_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = -1;
            }
        }
        AuthorDocumentFragment[] fragments = null;
        ArrayList<Map<String, String>> attributes = null;
        List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFrags = CommonsOperationsUtil.getSelectedFragmentsForConversions(authorAccess, CONVERSION_ELEMENT_CHECKER);
        if (selectedFrags != null) {
            fragments = new AuthorDocumentFragment[selectedFrags.size()];
            attributes = new ArrayList<Map<String, String>>(selectedFrags.size());
            for (int i = 0; i < selectedFrags.size(); ++i) {
                CommonsOperationsUtil.SelectedFragmentInfo currentFrag = selectedFrags.get(i);
                fragments[i] = currentFrag.getSelectedFragment();
                attributes.add(currentFrag.getAttributes());
            }
        }
        Object tableInfoObj = args.getArgumentValue("table_info");
        int minRows = fragments != null ? fragments.length : 0;
        TableInfo tableInfo = tableInfoObj != null ? new TableInfo((Map)tableInfoObj, minRows) : null;
        this.insertTable(fragments, attributes, false, authorAccess, (String)namespaceObj, null, tableInfo);
    }

    private StringBuilder getXMLFragment(TableInfo tableInfo, String namespace, boolean innerTable, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, AuthorTableHelper tableHelper) throws AuthorOperationException {
        AuthorElement root;
        String rootNamespace;
        boolean isDocBook5;
        StringBuilder tableXMLFragment = new StringBuilder();
        if (innerTable) {
            tableXMLFragment.append("<entrytbl ");
            if (tableInfo.getTitle() != null && namespace == null) {
                tableXMLFragment.append("title=\"").append(authorAccess.getXMLUtilAccess().escapeAttributeValue(tableInfo.getTitle())).append("\" ");
            }
            tableXMLFragment.append("cols=\"" + tableInfo.getColumnsNumber() + "\" ");
        } else if (tableInfo.getTitle() != null) {
            tableXMLFragment.append("<table ");
        } else {
            tableXMLFragment.append("<informaltable ");
        }
        if (namespace != null) {
            tableXMLFragment.append("xmlns=\"").append(namespace).append("\" ");
        }
        if (!innerTable && tableInfo.getFrame() != null) {
            tableXMLFragment.append(" frame=\"" + tableInfo.getFrame() + "\"");
        }
        if ((tableInfo.getTableModel() == 2 || tableInfo.getTableModel() == 1) && tableInfo.getRowsep() != null) {
            tableXMLFragment.append(" rowsep=\"" + tableInfo.getRowsep() + "\"");
        }
        if ((tableInfo.getTableModel() == 2 || tableInfo.getTableModel() == 1) && tableInfo.getColsep() != null) {
            tableXMLFragment.append(" colsep=\"" + tableInfo.getColsep() + "\"");
        }
        boolean bl = isDocBook5 = !(rootNamespace = (root = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement()).getNamespace()).isEmpty();
        if (tableInfo.getAlign() != null && tableInfo.getTableModel() == 0 && !isDocBook5) {
            tableXMLFragment.append(" align=\"" + tableInfo.getAlign() + "\"");
        }
        tableXMLFragment.append(">");
        if (tableInfo.getTableModel() == 2 || tableInfo.getTableModel() == 1 || innerTable) {
            this.addCALSXMLFragment(tableXMLFragment, tableInfo, namespace, innerTable, fragments, rowAttributes, cellsFragments, authorAccess, tableHelper);
        } else {
            this.addHTMLXMLFragment(tableXMLFragment, tableInfo, namespace, fragments, rowAttributes, cellsFragments, isDocBook5, authorAccess, tableHelper);
        }
        if (innerTable) {
            tableXMLFragment.append("</entrytbl>");
        } else if (tableInfo.getTitle() != null) {
            tableXMLFragment.append("</table>");
        } else {
            tableXMLFragment.append("</informaltable>");
        }
        return tableXMLFragment;
    }

    private void addCALSXMLFragment(StringBuilder tableXMLFragment, TableInfo tableInfo, String namespace, boolean innerTable, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, AuthorTableHelper tableHelper) throws AuthorOperationException {
        if (!innerTable && tableInfo.getTitle() != null) {
            tableXMLFragment.append("<title>" + authorAccess.getXMLUtilAccess().escapeTextValue(tableInfo.getTitle()) + "</title>");
        }
        if (!innerTable) {
            tableXMLFragment.append("<tgroup cols=\"" + tableInfo.getColumnsNumber() + "\"");
            if (tableInfo.getAlign() != null) {
                tableXMLFragment.append(" align=\"" + tableInfo.getAlign() + "\"");
            }
            tableXMLFragment.append(">");
        }
        InsertTableOperation.addCALSColSpecs(tableXMLFragment, tableInfo);
        this.addCALSTableHeader(tableXMLFragment, tableInfo);
        if (!innerTable) {
            this.addCALSTableFooter(tableXMLFragment, tableInfo);
        }
        this.addCALSTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, authorAccess, tableHelper, namespace);
        if (!innerTable) {
            tableXMLFragment.append("</tgroup>");
        }
    }

    private void addCALSTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, AuthorTableHelper tableHelper, String namespace) throws AuthorOperationException {
        tableXMLFragment.append("<tbody>");
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<row");
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            for (int j = 0; j < tableInfo.getColumnsNumber(); ++j) {
                if (j == 0 && fragments != null) {
                    String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, "entry", i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    continue;
                }
                tableXMLFragment.append("<entry>").append(this.cellContent).append("</entry>");
            }
            tableXMLFragment.append("</row>");
        }
        tableXMLFragment.append("</tbody>");
    }

    private void addCALSTableFooter(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        if (tableInfo.isGenerateFooter()) {
            tableXMLFragment.append("<tfoot><row>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<entry>").append(this.cellContent).append("</entry>");
            }
            tableXMLFragment.append("</row></tfoot>");
        }
    }

    private void addCALSTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        if (tableInfo.isGenerateHeader()) {
            tableXMLFragment.append("<thead><row>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<entry>").append(this.cellContent).append("</entry>");
            }
            tableXMLFragment.append("</row></thead>");
        }
    }

    private static void addCALSColSpecs(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        TableCustomizerConstants.ColumnWidthsType columnsWidthsType = tableInfo.getColumnsWidthsType();
        String colWidth = null;
        if (columnsWidthsType == TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS) {
            colWidth = "1*";
        } else if (columnsWidthsType == TableCustomizerConstants.ColumnWidthsType.FIXED_COL_WIDTHS) {
            colWidth = "75pt";
        }
        for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
            tableXMLFragment.append("<colspec colnum=\"" + i + "\" colname=\"c" + i + "\"");
            if (colWidth != null) {
                tableXMLFragment.append(" colwidth=\"" + colWidth + "\"");
            }
            tableXMLFragment.append("/>");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert a docbook table";
    }

    private void addHTMLXMLFragment(StringBuilder tableXMLFragment, TableInfo tableInfo, String namespace, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, boolean isDocBook5, AuthorAccess authorAccess, AuthorTableHelper tableHelper) throws AuthorOperationException {
        if (tableInfo.getTitle() != null) {
            tableXMLFragment.append("<caption>" + authorAccess.getXMLUtilAccess().escapeTextValue(tableInfo.getTitle()) + "</caption>");
        }
        InsertTableOperation.addHTMLTableCols(tableXMLFragment, tableInfo);
        this.addHTMLTableHeader(tableXMLFragment, tableInfo, isDocBook5);
        this.addHTMLTableFooter(tableXMLFragment, tableInfo, isDocBook5);
        this.addHTMLTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, isDocBook5, authorAccess, tableHelper, namespace);
    }

    private static void addHTMLTableCols(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        TableCustomizerConstants.ColumnWidthsType columnsWidthsType = tableInfo.getColumnsWidthsType();
        if (columnsWidthsType != TableCustomizerConstants.ColumnWidthsType.DYNAMIC_COL_WIDTHS) {
            Object colWidth = null;
            if (columnsWidthsType == TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS) {
                float proportionalWidth = 100.0f / (float)tableInfo.getColumnsNumber();
                colWidth = (int)((double)Math.round((double)proportionalWidth * 100.0) / 100.0) + "%";
            } else {
                colWidth = "75pt";
            }
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<col width=\"" + (String)colWidth + "\"/>");
            }
        }
    }

    private void addHTMLTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo, boolean isDocBook5) {
        if (tableInfo.isGenerateHeader()) {
            tableXMLFragment.append("<thead");
            if (tableInfo.getAlign() != null && isDocBook5) {
                tableXMLFragment.append(" align=\"" + tableInfo.getAlign() + "\"");
            }
            tableXMLFragment.append(">");
            tableXMLFragment.append("<tr>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<th>").append(this.cellContent).append("</th>");
            }
            tableXMLFragment.append("</tr></thead>");
        }
    }

    private void addHTMLTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, boolean isDocBook5, AuthorAccess authorAccess, AuthorTableHelper tableHelper, String namespace) throws AuthorOperationException {
        tableXMLFragment.append("<tbody");
        if (tableInfo.getAlign() != null && isDocBook5) {
            tableXMLFragment.append(" align=\"" + tableInfo.getAlign() + "\"");
        }
        tableXMLFragment.append(">");
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<tr");
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            for (int j = 0; j < tableInfo.getColumnsNumber(); ++j) {
                if (j == 0 && fragments != null) {
                    String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, "td", i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    continue;
                }
                tableXMLFragment.append("<td>").append(this.cellContent).append("</td>");
            }
            tableXMLFragment.append("</tr>");
        }
        tableXMLFragment.append("</tbody>");
    }

    private void addHTMLTableFooter(StringBuilder tableXMLFragment, TableInfo tableInfo, boolean isDocBook5) {
        if (tableInfo.isGenerateFooter()) {
            tableXMLFragment.append("<tfoot");
            if (tableInfo.getAlign() != null && isDocBook5) {
                tableXMLFragment.append(" align=\"" + tableInfo.getAlign() + "\"");
            }
            tableXMLFragment.append(">");
            tableXMLFragment.append("<tr>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<td>").append(this.cellContent).append("</td>");
            }
            tableXMLFragment.append("</tr></tfoot>");
        }
    }

    @Override
    public void insertTable(AuthorDocumentFragment[] fragments, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        this.insertTable(fragments, null, cellsFragments, authorAccess, namespace, tableHelper, tableInfo);
    }

    public void insertTable(AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        boolean addInnerTable = false;
        try {
            AuthorElement elem;
            AuthorNode node = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            if (node.getType() == 0 && "row".equals((elem = (AuthorElement)node).getLocalName())) {
                addInnerTable = true;
            }
        }
        catch (BadLocationException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        if (tableInfo == null) {
            Platform platform;
            int rowsCount = -1;
            int columnsCount = -1;
            if (fragments != null) {
                rowsCount = fragments.length;
                columnsCount = 1;
            }
            if (Platform.STANDALONE == (platform = authorAccess.getWorkspaceAccess().getPlatform())) {
                tableInfo = addInnerTable ? SADocbookInnerTableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount, this.defaultTableModel) : SADocbookTableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount, this.defaultTableModel);
            } else if (Platform.ECLIPSE == platform) {
                tableInfo = addInnerTable ? ECDocbookInnerTableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount, this.defaultTableModel) : ECDocbookTableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount, this.defaultTableModel);
            }
        }
        if (tableInfo == null) {
            throw new AuthorOperationStoppedByUserException("Cancelled by user");
        }
        List<Position> removeCurrentSelection = CommonsOperationsUtil.removeCurrentSelection(authorAccess);
        StringBuilder tableXMLFragment = this.getXMLFragment(tableInfo, namespace, addInnerTable, fragments, rowAttributes, cellsFragments, authorAccess, tableHelper);
        SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(tableXMLFragment.toString(), authorAccess.getEditorAccess().getCaretOffset());
        TableOperationsUtil.placeCaretInFirstCell(authorAccess, tableInfo, authorAccess.getDocumentController(), result);
        CommonsOperationsUtil.removeEmptyElements(authorAccess, removeCurrentSelection);
    }
}

