/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook.table;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.operations.ECTableCustomizerDialog;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLTableCustomizerConstants;
import ro.sync.ecss.extensions.docbook.table.DocbookTableCustomizerConstants;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECDocbookTableCustomizerDialog
extends ECTableCustomizerDialog {
    private boolean isDocBook5;
    private final boolean innerTable;

    public ECDocbookTableCustomizerDialog(AuthorAccess authorAccess, Shell parentShell, boolean innerTable, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount, int defaultTableModel) {
        super(authorAccess, parentShell, !innerTable, !innerTable, !innerTable, false, false, 1 == defaultTableModel, innerTable, !innerTable, !innerTable, true, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
        AuthorElement root = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        String rootNamespace = root.getNamespace();
        this.isDocBook5 = !rootNamespace.isEmpty();
        this.innerTable = innerTable;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.innerTable) {
            newShell.setText(this.authorResourceBundle.getMessage("Insert_entry_table"));
        }
    }

    @Override
    protected Button createTitleCheckbox(Composite parent) {
        Button titleCheckBox = new Button(parent, 32);
        titleCheckBox.setText(this.authorResourceBundle.getMessage("Title"));
        titleCheckBox.setToolTipText(this.authorResourceBundle.getMessage("Insert_informal_table_tooltip"));
        return titleCheckBox;
    }

    @Override
    protected List<TableCustomizerConstants.ColumnWidthsType> getColumnWidthsSpecifications(int tableModelType) {
        List<TableCustomizerConstants.ColumnWidthsType> toRet = null;
        if (tableModelType == 1) {
            toRet = Arrays.asList(CALS_WIDTHS_SPECIFICATIONS);
        } else if (tableModelType == 0) {
            toRet = Arrays.asList(HTML_WIDTHS_SPECIFICATIONS);
        }
        return toRet;
    }

    @Override
    protected String[] getFrameValues(int tableModelType) {
        String[] frameVals = DocbookTableCustomizerConstants.TABLE_FRAME_VALUES;
        if (tableModelType == 0) {
            frameVals = XHTMLTableCustomizerConstants.TABLE_FRAME_VALUES;
        }
        return frameVals;
    }

    @Override
    protected String getDefaultFrameValue(int tableModelType) {
        String defaultFrame = "all";
        if (tableModelType == 0) {
            defaultFrame = "void";
        }
        return defaultFrame;
    }

    @Override
    protected String[] getRowsepValues(int tableModelType) {
        return new String[]{"0", "1", "<unspecified>"};
    }

    @Override
    protected String[] getColsepValues(int tableModelType) {
        return new String[]{"0", "1", "<unspecified>"};
    }

    @Override
    protected String getDefaultRowsepValue(int tableModelType) {
        return "<unspecified>";
    }

    @Override
    protected String getDefaultColsepValue(int tableModelType) {
        return "<unspecified>";
    }

    @Override
    protected String[] getAlignValues(int tableModelType) {
        String[] alignVals;
        String[] stringArray = alignVals = this.isDocBook5 ? DocbookTableCustomizerConstants.ALIGN_VALUES_DB_5 : DocbookTableCustomizerConstants.ALIGN_VALUES_DB_4;
        if (tableModelType == 0) {
            alignVals = XHTMLTableCustomizerConstants.ALIGN_VALUES;
        }
        return alignVals;
    }

    @Override
    protected String getDefaultAlignValue(int tableModelType) {
        return "<unspecified>";
    }

    @Override
    public String getHelpPageID() {
        return "add-docbook-table";
    }
}

