/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook.link;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.docbook.link.InsertLinkUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
@WebappRestSafe
public class InsertExternalLinkOperation
implements AuthorOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InsertExternalLinkOperation.class.getName());
    private static final String DOCBOOK_NS = "http://docbook.org/ns/docbook";
    private static final String ARGUMENT_URL_VALUE = "url_value";

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        String urlValue = (String)args.getArgumentValue(ARGUMENT_URL_VALUE);
        if (urlValue == null) {
            urlValue = InsertLinkUtil.chooseURLForLink(authorAccess, authorAccess.getAuthorResourceBundle().getMessage("insert.web.link"));
        }
        this.insertExternalLink(urlValue, authorAccess, true);
    }

    public String getDescription() {
        return "Insert an external link";
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public void insertExternalLink(String url, AuthorAccess authorAccess, boolean schemaAware) throws AuthorOperationException {
        if (url != null) {
            StringBuilder linkXMLFragment = new StringBuilder();
            linkXMLFragment.append("<link ");
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            boolean addNSDecl = false;
            AuthorNode node = null;
            try {
                node = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            }
            catch (BadLocationException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            while (node != null && node.getType() != 0) {
                node = node.getParent();
            }
            if (node != null && DOCBOOK_NS.equals(((AuthorElement)node).getNamespace())) {
                addNSDecl = true;
            }
            if (addNSDecl) {
                linkXMLFragment.append("xmlns='").append(DOCBOOK_NS).append("' xmlns:xlink=\"http://www.w3.org/1999/xlink\" ");
                linkXMLFragment.append("xlink:href=\"").append(url).append("\"");
            } else {
                linkXMLFragment.append("href=\"").append(url).append("\"");
            }
            linkXMLFragment.append("/>");
            CommonsOperationsUtil.surroundWithFragment(authorAccess, schemaAware, linkXMLFragment.toString());
        }
    }
}

