/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook.link;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.WeakHashSet;
import ro.sync.ecss.extensions.api.AttributeChangedEvent;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorListener;
import ro.sync.ecss.extensions.api.AuthorListenerAdapter;
import ro.sync.ecss.extensions.api.link.InvalidLinkException;
import ro.sync.ecss.extensions.api.link.LinkTextResolver;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class DocbookLinkTextResolver
extends LinkTextResolver {
    private static final Logger logger = LoggerFactory.getLogger((String)DocbookLinkTextResolver.class.getName());
    private final Map<String, WeakHashSet<AuthorNode>> dependencies = new HashMap<String, WeakHashSet<AuthorNode>>();
    private final Map<String, WeakReference<AuthorElement>> idToAuthorNodeMap = new HashMap<String, WeakReference<AuthorElement>>();
    private AuthorListenerAdapter authorListenerAdapter = new AuthorListenerAdapter(){
        private String oldValue = null;

        public void beforeAttributeChange(AttributeChangedEvent e) {
            AuthorNode node = e.getOwnerAuthorNode();
            if (node instanceof AuthorElement) {
                AttrValue val = null;
                if ("xreflabel".equals(e.getAttributeName())) {
                    val = ((AuthorElement)node).getAttribute("id");
                    if (val == null) {
                        val = ((AuthorElement)node).getAttribute("xml:id");
                    }
                } else {
                    val = ((AuthorElement)node).getAttribute(e.getAttributeName());
                }
                this.oldValue = val != null ? val.getValue() : null;
            }
        }

        public void attributeChanged(AttributeChangedEvent e) {
            AttrValue newValue;
            WeakHashSet<AuthorNode> depNodes = DocbookLinkTextResolver.this.dependencies.remove(this.oldValue);
            this.refreshNodes(depNodes);
            AuthorNode node = e.getOwnerAuthorNode();
            if (node instanceof AuthorElement && (newValue = ((AuthorElement)node).getAttribute(e.getAttributeName())) != null) {
                depNodes = DocbookLinkTextResolver.this.dependencies.remove(newValue.getValue());
                this.refreshNodes(depNodes);
            }
        }

        private void refreshNodes(WeakHashSet<AuthorNode> depNodes) {
            if (depNodes != null) {
                for (AuthorNode authorNode : depNodes) {
                    if (authorNode == null || authorNode.getOwnerDocument() == null) continue;
                    DocbookLinkTextResolver.this.authorAccess.getEditorAccess().refresh(authorNode);
                }
            }
        }
    };
    private AuthorAccess authorAccess;

    public String resolveReference(AuthorNode node) throws InvalidLinkException {
        if (logger.isDebugEnabled()) {
            logger.debug("Resolve " + node);
        }
        String linkText = null;
        if (node.getType() == 0 && "xref".equals(((AuthorElement)node).getLocalName())) {
            AttrValue linkendOrHrefAttr;
            AuthorElement element = (AuthorElement)node;
            AttrValue attrValue = linkendOrHrefAttr = element.getAttribute("linkend") != null ? element.getAttribute("linkend") : element.getAttribute("xlink:href");
            if (linkendOrHrefAttr != null && linkendOrHrefAttr.getValue() != null) {
                linkText = this.resolveXrefReference(node, linkendOrHrefAttr.getValue());
            }
        }
        return linkText;
    }

    private String resolveXrefReference(AuthorNode node, String linkendOrHrefAttrValue) {
        String linkText = null;
        String referredElementName = null;
        AuthorDocument ownerDocument = node.getOwnerDocument();
        if (ownerDocument != null) {
            if (linkendOrHrefAttrValue.startsWith("#")) {
                linkendOrHrefAttrValue = linkendOrHrefAttrValue.substring(1);
            }
            WeakReference<AuthorElement> nodeRef = this.idToAuthorNodeMap.get(linkendOrHrefAttrValue);
            AuthorElement referredElement = null;
            if (nodeRef != null) {
                referredElement = (AuthorElement)nodeRef.get();
                if (referredElement == null) {
                    this.idToAuthorNodeMap.remove(linkendOrHrefAttrValue);
                } else if (this.getIDAttribute(referredElement, linkendOrHrefAttrValue) == null) {
                    this.idToAuthorNodeMap.remove(linkendOrHrefAttrValue);
                    referredElement = null;
                }
            }
            if (referredElement == null) {
                referredElement = this.findElementWithId((AuthorNode)ownerDocument, linkendOrHrefAttrValue);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Referred " + referredElement);
            }
            if (referredElement != null) {
                AttrValue xrefLabelAttr = referredElement.getAttribute("xreflabel");
                referredElementName = referredElement.getLocalName();
                if (xrefLabelAttr != null && xrefLabelAttr.getValue() != null) {
                    linkText = xrefLabelAttr.getValue();
                } else if ("varlistentry".equals(referredElementName)) {
                    AuthorElement[] elementsByLocalName = referredElement.getElementsByLocalName("term");
                    if (elementsByLocalName != null && elementsByLocalName.length > 0) {
                        AuthorElement term = elementsByLocalName[0];
                        try {
                            linkText = term.getTextContent();
                        }
                        catch (BadLocationException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                } else if ("bridgehead".equals(referredElementName) || "term".equals(referredElementName)) {
                    try {
                        linkText = referredElement.getTextContent();
                    }
                    catch (BadLocationException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    linkText = DocbookLinkTextResolver.getTitleValue(referredElement);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(((Object)((Object)this)).hashCode() + " put " + node + " to " + referredElementName);
        }
        WeakHashSet deps = this.dependencies.computeIfAbsent(linkendOrHrefAttrValue, key -> new WeakHashSet());
        deps.add((Object)node);
        return linkText;
    }

    public void refresh() {
        this.dependencies.clear();
        this.idToAuthorNodeMap.clear();
    }

    public void clearReferencesCache() {
        this.dependencies.clear();
        this.idToAuthorNodeMap.clear();
    }

    private AuthorElement findElementWithId(AuthorNode node, String id) {
        AuthorElement elem;
        AuthorElement elementToReturn = null;
        if (node.getType() == 0 && this.getIDAttribute(elem = (AuthorElement)node, id) != null) {
            elementToReturn = elem;
        }
        if (elementToReturn == null) {
            List childNodes = ((AuthorParentNode)node).getContentNodes();
            int size = childNodes.size();
            for (int i = 0; i < size && (elementToReturn = this.findElementWithId((AuthorNode)childNodes.get(i), id)) == null; ++i) {
            }
        }
        return elementToReturn;
    }

    private String getIDAttribute(AuthorElement elem, String id) {
        String found = null;
        int count = elem.getAttributesCount();
        for (int i = 0; i < count; ++i) {
            String attributeName = elem.getAttributeAtIndex(i);
            if (!"id".equals(attributeName) && !"xml:id".equals(attributeName)) continue;
            String idValue = elem.getAttribute(attributeName).getValue();
            this.idToAuthorNodeMap.put(idValue, new WeakReference<AuthorElement>(elem));
            if (!id.equals(idValue)) continue;
            found = attributeName;
            break;
        }
        return found;
    }

    public static String getTitleValue(AuthorElement elem) {
        String title = null;
        try {
            if ("title".equals(elem.getLocalName())) {
                title = elem.getTextContent();
            } else {
                AuthorElement firstElement = DocbookLinkTextResolver.getFirstChildElement(elem);
                if (firstElement != null) {
                    AuthorElement titleElement;
                    if ("title".equals(firstElement.getLocalName())) {
                        title = firstElement.getTextContent();
                    } else if ("info".equals(firstElement.getLocalName()) && (titleElement = DocbookLinkTextResolver.getFirstChildElement(firstElement)) != null && "title".equals(titleElement.getLocalName())) {
                        title = titleElement.getTextContent();
                    }
                }
            }
        }
        catch (BadLocationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return title;
    }

    private static AuthorElement getFirstChildElement(AuthorElement elem) {
        List contentNodes = elem.getContentNodes();
        AuthorElement firstElement = null;
        for (AuthorNode authorNode : contentNodes) {
            if (authorNode.getType() != 0) continue;
            firstElement = (AuthorElement)authorNode;
            break;
        }
        return firstElement;
    }

    public void activated(AuthorAccess authorAccess) {
        this.authorAccess = authorAccess;
        authorAccess.getDocumentController().addAuthorListener((AuthorListener)this.authorListenerAdapter);
    }

    public void deactivated(AuthorAccess authorAccess) {
        this.authorAccess = null;
        authorAccess.getDocumentController().removeAuthorListener((AuthorListener)this.authorListenerAdapter);
    }
}

