/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorElementBaseInterface;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class PromoteDemoteSectionUtil {
    private static final String NESTED_SECTION_ELEMENT_NO_5 = "sect5";
    private static final String NESTED_SECTION_NAME = "sect";
    private static final String SECTION_NAME = "section";
    private static final Logger logger = LoggerFactory.getLogger((String)PromoteDemoteSectionUtil.class.getName());
    private static final String DOCBOOK5_NAMESPACE = "http://docbook.org/ns/docbook";

    public static void processPromoteDemote(AuthorAccess authorAccess, PromoteDemote action) {
        int insertionOffset;
        AuthorNode sectionNodeToProcess = PromoteDemoteSectionUtil.getSectionNodeToProcess(authorAccess);
        if (sectionNodeToProcess instanceof AuthorElement && (insertionOffset = PromoteDemoteSectionUtil.getInsertionOffset(authorAccess, (AuthorElement)sectionNodeToProcess, action)) != -1) {
            AuthorElement sectionNodeElement = (AuthorElement)sectionNodeToProcess;
            String elementName = ((AuthorElement)sectionNodeToProcess).getLocalName();
            if (!SECTION_NAME.equals(elementName)) {
                PromoteDemoteSectionUtil.changeSectNodeName(authorAccess, sectionNodeElement, action);
            }
            try {
                int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                int relativeCaretOffset = caretOffset - sectionNodeToProcess.getStartOffset();
                AuthorDocumentFragment sectionDocumentFragment = authorAccess.getDocumentController().createDocumentFragment(sectionNodeToProcess, true);
                authorAccess.getDocumentController().insertFragment(insertionOffset, sectionDocumentFragment);
                authorAccess.getDocumentController().deleteNode(sectionNodeToProcess);
                int nextCaretPosition = insertionOffset + relativeCaretOffset;
                if (action == PromoteDemote.PROMOTE) {
                    nextCaretPosition -= sectionDocumentFragment.getLength();
                }
                authorAccess.getEditorAccess().setCaretPosition(nextCaretPosition);
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static AuthorNode getSectionNodeToProcess(AuthorAccess authorAccess) {
        AuthorElement nodeToReturn = null;
        try {
            int selectionStart = authorAccess.getEditorAccess().getSelectionStart();
            int selectionEnd = authorAccess.getEditorAccess().getSelectionEnd();
            AuthorNode startingNode = null;
            if (selectionStart == selectionEnd) {
                int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                startingNode = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            } else {
                List nodesToSelect = authorAccess.getDocumentController().getNodesToSelect(selectionStart, selectionEnd);
                if (nodesToSelect.size() == 1) {
                    startingNode = (AuthorNode)nodesToSelect.get(0);
                } else {
                    AuthorNode[] nodesArray = nodesToSelect.toArray(new AuthorNode[0]);
                    startingNode = authorAccess.getDocumentController().getCommonAncestor(nodesArray);
                }
            }
            if (startingNode instanceof AuthorElement) {
                nodeToReturn = (AuthorElement)startingNode;
                while ((!nodeToReturn.getLocalName().equals(SECTION_NAME) && !nodeToReturn.getLocalName().startsWith(NESTED_SECTION_NAME) || !nodeToReturn.getNamespace().isEmpty() && !nodeToReturn.getNamespace().equals(DOCBOOK5_NAMESPACE)) && nodeToReturn.getParentElement() instanceof AuthorElement) {
                    nodeToReturn = (AuthorElement)nodeToReturn.getParentElement();
                }
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return nodeToReturn;
    }

    private static int getInsertionOffset(AuthorAccess authorAccess, AuthorElement sectionNodeToProcess, PromoteDemote action) {
        int insertionOffset = -1;
        insertionOffset = action == PromoteDemote.PROMOTE ? PromoteDemoteSectionUtil.getInsertionOffsetForPromote(authorAccess, sectionNodeToProcess) : PromoteDemoteSectionUtil.getInsertionOffsetForDemote(sectionNodeToProcess);
        return insertionOffset;
    }

    private static int getInsertionOffsetForPromote(AuthorAccess authorAccess, AuthorElement sectionNodeToProcess) {
        AuthorElement sectionNodeParent;
        int insertionOffset = -1;
        if (sectionNodeToProcess.getParentElement() != null && (sectionNodeParent = (AuthorElement)sectionNodeToProcess.getParentElement()) != null && sectionNodeParent.getParent() != authorAccess.getDocumentController().getAuthorDocumentNode() && (sectionNodeToProcess.getNamespace().isEmpty() || sectionNodeToProcess.getNamespace().equals(DOCBOOK5_NAMESPACE))) {
            if (sectionNodeToProcess.getLocalName().equals(SECTION_NAME)) {
                if (sectionNodeParent.getLocalName().equals(SECTION_NAME) && (sectionNodeToProcess.getNamespace().isEmpty() || sectionNodeToProcess.getNamespace().equals(DOCBOOK5_NAMESPACE))) {
                    insertionOffset = sectionNodeParent.getEndOffset() + 1;
                }
            } else if (sectionNodeParent.getLocalName().startsWith(NESTED_SECTION_NAME)) {
                insertionOffset = sectionNodeParent.getEndOffset() + 1;
            }
        }
        return insertionOffset;
    }

    private static int getInsertionOffsetForDemote(AuthorElement sectionNodeToProcess) {
        AuthorElement previousSiblingElement;
        AuthorNode previousSibling;
        List childNodes;
        int sectionNodeToProcessIndex;
        AuthorElementBaseInterface parentElement;
        int insertionOffset = -1;
        if ((sectionNodeToProcess.getNamespace().isEmpty() || sectionNodeToProcess.getNamespace().equals(DOCBOOK5_NAMESPACE)) && (sectionNodeToProcess.getLocalName().equals(SECTION_NAME) || !PromoteDemoteSectionUtil.nodeContainsSect5Element((AuthorElementBaseInterface)sectionNodeToProcess)) && (parentElement = sectionNodeToProcess.getParentElement()) != null && (sectionNodeToProcessIndex = (childNodes = parentElement.getContentNodes()).indexOf(sectionNodeToProcess)) != -1 && sectionNodeToProcessIndex > 0 && (previousSibling = (AuthorNode)parentElement.getContentNodes().get(sectionNodeToProcessIndex - 1)) instanceof AuthorElement && ((previousSiblingElement = (AuthorElement)previousSibling).getLocalName().equals(SECTION_NAME) || previousSiblingElement.getLocalName().startsWith(NESTED_SECTION_NAME)) && (previousSiblingElement.getNamespace().isEmpty() || previousSiblingElement.getNamespace().equals(DOCBOOK5_NAMESPACE))) {
            insertionOffset = previousSibling.getEndOffset();
        }
        return insertionOffset;
    }

    private static void changeSectNodeName(AuthorAccess authorAccess, AuthorElement authorElement, PromoteDemote action) {
        if (authorElement != null) {
            if (authorElement.getLocalName().startsWith(NESTED_SECTION_NAME) && (authorElement.getNamespace().isEmpty() || authorElement.getNamespace().equals(DOCBOOK5_NAMESPACE))) {
                try {
                    int currentIndex = NumberParserUtil.parseInt((String)authorElement.getLocalName().substring(NESTED_SECTION_NAME.length()));
                    if (action == PromoteDemote.DEMOTE) {
                        if (currentIndex < 5) {
                            ++currentIndex;
                        }
                    } else if (currentIndex > 1) {
                        --currentIndex;
                    }
                    String newSectNodeName = NESTED_SECTION_NAME + currentIndex;
                    String prefix = CommonsOperationsUtil.getPrefix(authorElement.getName());
                    if (prefix != null && !prefix.isEmpty()) {
                        newSectNodeName = prefix + ":" + newSectNodeName;
                    }
                    authorAccess.getDocumentController().renameElement(authorElement, newSectNodeName);
                }
                catch (NumberFormatException currentIndex) {
                    // empty catch block
                }
            }
            List contentNodes = authorElement.getContentNodes();
            for (int i = 0; i < contentNodes.size(); ++i) {
                if (!(contentNodes.get(i) instanceof AuthorElement)) continue;
                PromoteDemoteSectionUtil.changeSectNodeName(authorAccess, (AuthorElement)contentNodes.get(i), action);
            }
        }
    }

    public static boolean nodeContainsSect5Element(AuthorElementBaseInterface sectionElement) {
        boolean toReturn = false;
        if (sectionElement.getNamespace().isEmpty() || sectionElement.getNamespace().equals(DOCBOOK5_NAMESPACE)) {
            List contentNodes = sectionElement.getContentNodes();
            if (contentNodes.isEmpty()) {
                toReturn = NESTED_SECTION_ELEMENT_NO_5.equals(sectionElement.getLocalName());
            } else if (!NESTED_SECTION_ELEMENT_NO_5.equals(sectionElement.getLocalName())) {
                for (int i = 0; i < contentNodes.size(); ++i) {
                    if (!(contentNodes.get(i) instanceof AuthorElement) || !PromoteDemoteSectionUtil.nodeContainsSect5Element((AuthorElementBaseInterface)((AuthorElement)contentNodes.get(i)))) continue;
                    toReturn = true;
                    break;
                }
            } else {
                toReturn = true;
            }
        }
        return toReturn;
    }

    public static enum PromoteDemote {
        PROMOTE,
        DEMOTE;

    }
}

