/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.docbook.DocBookImageInfo;
import ro.sync.ecss.docbook.DocbookAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.ImageFileChooser;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class InsertGraphicOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)InsertGraphicOperation.class.getName());
    public static final String ARGUMENT_IMAGE_URL = "imageUrl";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("imageUrl", 0, "The URL of the image. If not defined, an image chooser will be shown.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object imageUrl = args.getArgumentValue(ARGUMENT_IMAGE_URL);
        DocBookImageInfo imageInfo = null;
        boolean isInlineGraphicAccepted = false;
        try {
            isInlineGraphicAccepted = CommonsOperationsUtil.isAllowedElement("inlinegraphic", authorAccess.getEditorAccess().getCaretOffset(), authorAccess.getDocumentController().getAuthorSchemaManager());
        }
        catch (BadLocationException e) {
            logger.warn((Object)e, (Throwable)e);
        }
        if (imageUrl instanceof String) {
            imageInfo = new DocBookImageInfo();
            imageInfo.addProperty("href", ImageFileChooser.makeUrlRelative(authorAccess, (String)imageUrl));
        } else if (isInlineGraphicAccepted) {
            String url = ImageFileChooser.chooseImageFile(authorAccess);
            imageInfo = new DocBookImageInfo();
            imageInfo.addProperty("href", url);
        } else {
            imageInfo = DocbookAccess.chooseImageReference((AuthorAccess)authorAccess);
        }
        if (imageInfo != null) {
            InsertGraphicOperation.insertImageRef(authorAccess, imageInfo, isInlineGraphicAccepted);
        }
    }

    public static SchemaAwareHandlerResult insertImageRef(AuthorAccess authorAccess, DocBookImageInfo imageInfo, boolean isInlineGraphicAccepted) throws AuthorOperationException {
        SchemaAwareHandlerResult result = null;
        String url = authorAccess.getXMLUtilAccess().escapeAttributeValue(imageInfo.getValue("href"));
        if (url != null) {
            AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
            boolean insertImageRef = true;
            try {
                AuthorElement elementAtOffset;
                AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(editorAccess.getCaretOffset());
                if (nodeAtOffset.getType() == 0 && ("inlinegraphic".equals((elementAtOffset = (AuthorElement)nodeAtOffset).getLocalName()) || "imagedata".equals(elementAtOffset.getLocalName()))) {
                    authorAccess.getDocumentController().setAttribute("fileref", new AttrValue(url), elementAtOffset);
                    insertImageRef = false;
                }
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
            if (insertImageRef) {
                StringBuilder fragment = new StringBuilder();
                if (isInlineGraphicAccepted) {
                    fragment.append("<inlinegraphic fileref=\"").append(url).append("\"/>");
                } else {
                    String title = imageInfo.getValue("title");
                    if (title != null) {
                        fragment.append("<figure>\n");
                        fragment.append("    <title>").append(title).append("</title>\n");
                    } else {
                        fragment.append("<informalfigure>\n");
                    }
                    fragment.append("    <mediaobject>\n");
                    fragment.append("        <imageobject><imagedata fileref=\"").append(url).append("\"/></imageobject>\n");
                    fragment.append("    </mediaobject>\n");
                    if (title != null) {
                        fragment.append("</figure>\n");
                    } else {
                        fragment.append("</informalfigure>\n");
                    }
                }
                result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(fragment.toString(), editorAccess.getCaretOffset(), true);
            }
        }
        return result;
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }

    public String getDescription() {
        return "Insert a docbook graphic";
    }
}

