/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class InsertEquationOperation
extends ro.sync.ecss.extensions.commons.operations.InsertEquationOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InsertEquationOperation.class.getName());
    private static final String DOCBOOK_NS = "http://docbook.org/ns/docbook";

    @Override
    protected String createDefaultFragmentToEdit(AuthorAccess authorAccess, AuthorSchemaManager asm) {
        StringBuilder fragment = new StringBuilder();
        try {
            AuthorNode node;
            AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
            AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
            int caretOffset = editorAccess.getCaretOffset();
            boolean addNSDecl = false;
            for (node = authorAccess.getDocumentController().getNodeAtOffset(caretOffset); node != null && node.getType() != 0; node = node.getParent()) {
            }
            if (node != null && DOCBOOK_NS.equals(((AuthorElement)node).getNamespace())) {
                addNSDecl = true;
            }
            boolean isInlineEquationAccepted = false;
            try {
                isInlineEquationAccepted = CommonsOperationsUtil.isAllowedElement("inlineequation", editorAccess.getCaretOffset(), authorSchemaManager);
            }
            catch (BadLocationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (isInlineEquationAccepted) {
                fragment.append("<inlineequation");
                if (addNSDecl) {
                    fragment.append(" xmlns='").append(DOCBOOK_NS).append("'>");
                } else {
                    fragment.append('>');
                }
                fragment.append(MATH_ML).append("</inlineequation>");
            } else {
                fragment.append("<equation");
                if (addNSDecl) {
                    fragment.append(" xmlns='").append(DOCBOOK_NS).append("'>");
                } else {
                    fragment.append('>');
                }
                fragment.append(MATH_ML).append("</equation>");
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return fragment.toString();
    }
}

