/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DocbookNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)DocbookNodeRendererCustomizer.class.getName());
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();

    private static String getImageURL(String path) {
        URL imageURL = DocbookNodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(DocbookNodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            Object imageKey = nodeName;
            if ("emphasis".equals(nodeName)) {
                String roleValue = context.getAttributeValue("role");
                imageKey = "bold".equals(roleValue) ? (String)imageKey + "@bold" : ("underline".equals(roleValue) ? (String)imageKey + "@underline" : (String)imageKey + "@italic");
            }
            String iconPath = nameToIconPath.get(imageKey);
            renderingInfo.setIconPath(iconPath);
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "Docbook Node Renderer Customizer";
    }

    static {
        String docbookRoot = DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementDocbook16.png");
        nameToIconPath.put("article", docbookRoot);
        nameToIconPath.put("book", docbookRoot);
        nameToIconPath.put("link", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLink16.png"));
        nameToIconPath.put("figure", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementImage16.png"));
        nameToIconPath.put("listitem", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLi16.png"));
        nameToIconPath.put("orderedlist", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOl16.png"));
        nameToIconPath.put("itemizedlist", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUl16.png"));
        nameToIconPath.put("para", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementPara16.png"));
        nameToIconPath.put("table", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTable16.png"));
        nameToIconPath.put("tbody", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTBody16.png"));
        String tableCellIcon = DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTd16.png");
        nameToIconPath.put("entry", tableCellIcon);
        nameToIconPath.put("td", tableCellIcon);
        nameToIconPath.put("tfoot", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTFoot16.png"));
        nameToIconPath.put("thead", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTHead16.png"));
        String titleIcon = DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTitle16.png");
        nameToIconPath.put("title", titleIcon);
        nameToIconPath.put("caption", titleIcon);
        String tableRowIcon = DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTr16.png");
        nameToIconPath.put("row", tableRowIcon);
        nameToIconPath.put("tr", tableRowIcon);
        nameToIconPath.put("sect1", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH116.png"));
        nameToIconPath.put("sect2", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH216.png"));
        nameToIconPath.put("sect3", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH316.png"));
        nameToIconPath.put("sect4", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH416.png"));
        nameToIconPath.put("sect5", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH516.png"));
        nameToIconPath.put("indexterm", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementIndexterm16.png"));
        nameToIconPath.put("emphasis@bold", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBold16.png"));
        nameToIconPath.put("emphasis@italic", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementItalic16.png"));
        nameToIconPath.put("emphasis@underline", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUnderline16.png"));
        nameToIconPath.put("audiodata", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementAudio16.png"));
        nameToIconPath.put("audioobject", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementAudio16.png"));
        nameToIconPath.put("videodata", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementVideo16.png"));
        nameToIconPath.put("videoobject", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementVideo16.png"));
        nameToIconPath.put("mediaobject", DocbookNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementMedia16.png"));
    }
}

