/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.operations.InsertListOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public abstract class DocbookInsertListOperation
extends InsertListOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)DocbookInsertListOperation.class.getName());
    protected static final String ORDERED_LIST = "orderedlist";
    protected static final String ITEMIZED_LIST = "itemizedlist";
    protected static final String VARIABLE_LIST = "variablelist";
    protected static final String PROCEDURE = "procedure";
    private static final String LIST_ITEM = "listitem";
    private static final String VARLIST_ENTRY = "varlistentry";
    private static final String STEP = "step";
    private static final Set<String> LIST_ELEMENTS = ImmutableSet.of((Object)"orderedlist", (Object)"itemizedlist", (Object)"variablelist", (Object)"procedure");
    private static final Set<String> LIST_ITEM_ELEMENTS = ImmutableSet.of((Object)"listitem", (Object)"varlistentry", (Object)"step");
    public static final String LIST_TYPE_ARGUMENT = "listType";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, new ArgumentDescriptor("listType", 3, "Controls the type of list to be inserted. Accepted values are: orderedlist, itemizedlist, variablelist, procedure. Default value is orderedlist.", new String[]{"orderedlist", "itemizedlist", "variablelist", "procedure"}, "orderedlist"), CONVERT_ELEMENT_AT_CARET_ARGUMENT_DESCRIPTOR};

    @Override
    protected StringBuilder getListXMLFragment(String listType, Map<String, String> attributes, int numberOfListItems, AuthorAccess authorAccess) {
        StringBuilder listXMLFragment = new StringBuilder();
        listXMLFragment.append("<").append(listType);
        String namespace = this.getNamespace();
        if (namespace != null) {
            listXMLFragment.append(" xmlns=\"").append(namespace).append("\"");
        }
        listXMLFragment.append(CommonsOperationsUtil.serializeAttributes(attributes, Collections.emptySet()));
        listXMLFragment.append(">");
        for (int i = 0; i < numberOfListItems; ++i) {
            listXMLFragment.append(DocbookInsertListOperation.getLIContent(listType, false));
        }
        listXMLFragment.append("</").append(listType).append(">");
        return listXMLFragment;
    }

    @Override
    protected String getXMLFragment(AuthorAccess authorAccess, String listType, String parentListType) {
        StringBuilder frag = new StringBuilder();
        String liContent = DocbookInsertListOperation.getLIContent(listType, true);
        String namespace = this.getNamespace();
        if (ORDERED_LIST.equals(parentListType) || ITEMIZED_LIST.equals(parentListType)) {
            frag.append("<listitem");
            if (namespace != null) {
                frag.append(" xmlns=\"").append(namespace).append("\"");
            }
            frag.append(">");
        }
        frag.append("<").append(listType);
        if (namespace != null) {
            frag.append(" xmlns=\"").append(namespace).append("\"");
        }
        frag.append(">").append(liContent).append("</").append(listType).append(">");
        if (ORDERED_LIST.equals(parentListType) || ITEMIZED_LIST.equals(parentListType)) {
            frag.append("</listitem>");
        }
        return frag.toString();
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    private static String getLIContent(String listType, boolean addPara) {
        StringBuilder liContent = new StringBuilder();
        if (ORDERED_LIST.equals(listType) || ITEMIZED_LIST.equals(listType)) {
            liContent.append("<listitem>");
            if (addPara) {
                liContent.append("<para/>");
            }
            liContent.append("</listitem>");
        } else if (VARIABLE_LIST.equals(listType)) {
            liContent.append("<varlistentry><term/><listitem>");
            if (addPara) {
                liContent.append("<para/>");
            }
            liContent.append("</listitem></varlistentry>");
        } else if (PROCEDURE.equals(listType)) {
            liContent.append("<step>");
            if (addPara) {
                liContent.append("<para/>");
            }
            liContent.append("</step>");
        }
        return liContent.toString();
    }

    public String getDescription() {
        return "Convert the selected paragraph(s) to an ordered/unordered/variable list or procedure.";
    }

    @Override
    protected void insertContent(AuthorAccess authorAccess, AuthorNode listNode, List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFragmentsInfos) {
        if (listNode instanceof AuthorElement) {
            String listElemName = ((AuthorElement)listNode).getLocalName();
            List contentNodes = ((AuthorElement)listNode).getContentNodes();
            ArrayList<Position> startPos = new ArrayList<Position>();
            ArrayList<Position> endPos = new ArrayList<Position>();
            for (int i = 0; i < contentNodes.size(); ++i) {
                AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                if (!(authorNode instanceof AuthorElement) || i >= selectedFragmentsInfos.size()) continue;
                try {
                    Integer offset;
                    SchemaAwareHandlerResult result;
                    String localName = ((AuthorElement)authorNode).getLocalName();
                    AuthorDocumentFragment selectedFragment = selectedFragmentsInfos.get(i).getSelectedFragment();
                    StringBuilder xmlFragment = this.getFragmentToInsert(authorAccess, selectedFragmentsInfos.get(i));
                    if ((ORDERED_LIST.equals(listElemName) || ITEMIZED_LIST.equals(listElemName)) && LIST_ITEM.equals(localName)) {
                        result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment.toString(), authorNode.getStartOffset() + 1, 7, false);
                        offset = (Integer)result.getResult("result.id.handle.insert.fragment.offset");
                        Position position = authorAccess.getDocumentController().createPositionInContent(offset + 1);
                        startPos.add(position);
                        endPos.add(authorAccess.getDocumentController().createPositionInContent(offset + 1 + selectedFragment.getLength()));
                        continue;
                    }
                    if (VARIABLE_LIST.equals(listElemName) && VARLIST_ENTRY.equals(localName)) {
                        List varlistentryContentNodes = ((AuthorElement)authorNode).getContentNodes();
                        SchemaAwareHandlerResult result2 = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment.toString(), ((AuthorNode)varlistentryContentNodes.get(1)).getStartOffset() + 1, 7, false);
                        Integer offset2 = (Integer)result2.getResult("result.id.handle.insert.fragment.offset");
                        startPos.add(authorAccess.getDocumentController().createPositionInContent(offset2 + 1));
                        endPos.add(authorAccess.getDocumentController().createPositionInContent(offset2 + 1 + selectedFragment.getLength()));
                        continue;
                    }
                    if (!PROCEDURE.equals(listElemName) || !STEP.equals(localName)) continue;
                    result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment.toString(), authorNode.getStartOffset() + 1, 7, false);
                    offset = (Integer)result.getResult("result.id.handle.insert.fragment.offset");
                    startPos.add(authorAccess.getDocumentController().createPositionInContent(offset.intValue()));
                    endPos.add(authorAccess.getDocumentController().createPositionInContent(offset + selectedFragment.getLength()));
                    continue;
                }
                catch (BadLocationException | AuthorOperationException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (!startPos.isEmpty() && !endPos.isEmpty() && startPos.size() == endPos.size()) {
                for (int k = 0; k < startPos.size(); ++k) {
                    authorAccess.getEditorAccess().getAuthorSelectionModel().addSelection(((Position)startPos.get(k)).getOffset(), ((Position)endPos.get(k)).getOffset());
                }
            }
        }
    }

    private StringBuilder getFragmentToInsert(AuthorAccess authorAccess, CommonsOperationsUtil.SelectedFragmentInfo selectedFragmentInfo) throws BadLocationException {
        AuthorElement authorElement;
        AuthorDocumentFragment selectedFragment = selectedFragmentInfo.getSelectedFragment();
        AuthorElement insertedPara = null;
        List nodesInFragment = selectedFragment.getContentNodes();
        if (nodesInFragment.size() == 1 && ((AuthorNode)nodesInFragment.get(0)).getType() == 0 && "para".equals((authorElement = (AuthorElement)nodesInFragment.get(0)).getLocalName())) {
            insertedPara = authorElement;
        }
        StringBuilder xmlFragment = new StringBuilder();
        String namespace = this.getNamespace();
        Map<Object, Object> attributes = selectedFragmentInfo.getAttributes() != null ? selectedFragmentInfo.getAttributes() : Collections.emptyMap();
        attributes.keySet().removeIf(attrName -> !"xml:id".equals(attrName) && !"id".equals(attrName));
        AuthorDocumentController controller = authorAccess.getDocumentController();
        if (insertedPara == null) {
            xmlFragment.append("<para");
            if (namespace != null) {
                xmlFragment.append(" xmlns=\"").append(namespace).append("\"");
            }
            xmlFragment.append(CommonsOperationsUtil.serializeAttributes(attributes, Collections.singleton("xmlns")));
            xmlFragment.append(">");
            xmlFragment.append(controller.serializeFragmentToXML(selectedFragment));
            xmlFragment.append("</para>");
        } else {
            for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                String attributeValue = (String)attr.getValue();
                insertedPara.setAttribute((String)attr.getKey(), new AttrValue(attributeValue));
            }
            xmlFragment.append(controller.serializeFragmentToXML(selectedFragment));
        }
        return xmlFragment;
    }

    @Override
    protected CommonsOperationsUtil.ConversionElementHelper getConversionElementsChecker() {
        return new CommonsOperationsUtil.ConversionElementHelper(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
                boolean treatAsBlockToConvert = false;
                if (!(node instanceof AuthorElement)) throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("list.convert.exception"));
                AuthorElement element = (AuthorElement)node;
                String name = element.getLocalName();
                if (name == null) return treatAsBlockToConvert;
                boolean childOfVarlist = false;
                if ("term".equals(name)) {
                    AuthorNode parent = element.getParent();
                    if (parent instanceof AuthorElement && DocbookInsertListOperation.VARLIST_ENTRY.equals(((AuthorElement)parent).getLocalName())) {
                        return false;
                    }
                    if (childOfVarlist) return false;
                    return true;
                }
                if ("para".equals(name)) {
                    AuthorNode parent = element.getParent();
                    if (parent instanceof AuthorElement && DocbookInsertListOperation.LIST_ITEM.equals(((AuthorElement)parent).getLocalName())) {
                        childOfVarlist = this.isValListEntryChild(parent);
                    }
                    if (childOfVarlist) return false;
                    return true;
                }
                if (DocbookInsertListOperation.LIST_ITEM.equals(name) || DocbookInsertListOperation.ITEMIZED_LIST.equals(name) || DocbookInsertListOperation.ORDERED_LIST.equals(name)) {
                    childOfVarlist = this.isValListEntryChild((AuthorNode)element);
                    if (childOfVarlist) return false;
                    return true;
                }
                if (LIST_ELEMENTS.contains(name)) return true;
                if (LIST_ITEM_ELEMENTS.contains(name)) return true;
                if (!"dt".equals(name)) throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("list.convert.exception"));
                return true;
            }

            private boolean isValListEntryChild(AuthorNode node) {
                boolean childOfVarlist = false;
                for (AuthorNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof AuthorElement) || !DocbookInsertListOperation.VARLIST_ENTRY.equals(((AuthorElement)parent).getLocalName())) continue;
                    childOfVarlist = true;
                    break;
                }
                return childOfVarlist;
            }

            @Override
            public AuthorDocumentFragment createAuthorDocumentFragment(AuthorDocumentController controller, int start, int end) throws AuthorOperationException, BadLocationException {
                AuthorDocumentFragment fragment = null;
                OffsetInformation info = controller.getContentInformationAtOffset(start);
                if (info.getPositionType() == 1 || start == info.getNodeForOffset().getStartOffset() + 1) {
                    AuthorNode node = info.getNodeForMarkerOffset();
                    if (node == null) {
                        node = info.getNodeForOffset();
                    }
                    if (node instanceof AuthorElement && "term".equals(((AuthorElement)node).getLocalName())) {
                        List contentNodes;
                        AuthorNode nodeAtOffset;
                        boolean sepAppended = false;
                        StringBuilder newContentBuilder = new StringBuilder();
                        String termFrag = DocbookInsertListOperation.computeFragment(node, true, start, end, controller);
                        if (termFrag != null) {
                            newContentBuilder.append(termFrag);
                        }
                        if ((nodeAtOffset = controller.getNodeAtOffset(node.getEndOffset() + 2)) instanceof AuthorElement && DocbookInsertListOperation.LIST_ITEM.equals(((AuthorElement)nodeAtOffset).getLocalName()) && (contentNodes = ((AuthorElement)nodeAtOffset).getContentNodes()) != null) {
                            for (AuthorNode authorNode : contentNodes) {
                                Styles styles;
                                String display;
                                boolean isBlock;
                                String newFrag = DocbookInsertListOperation.computeFragment(authorNode, isBlock = "block".equals(display = (styles = DocbookInsertListOperation.this.authorAccess.getEditorAccess().getStyles(authorNode)).getDisplay()) || "list-item".equals(display), start, end, controller);
                                if (newFrag == null) continue;
                                if (!sepAppended && newContentBuilder.length() > 0) {
                                    newContentBuilder.append(" - ");
                                    sepAppended = !sepAppended;
                                }
                                newContentBuilder.append(newFrag);
                            }
                        }
                        fragment = controller.createNewDocumentFragmentInContext(newContentBuilder.toString(), node.getStartOffset());
                    }
                }
                return fragment;
            }
        };
    }

    private static String computeFragment(AuthorNode node, boolean isBlock, int startSelection, int endSelection, AuthorDocumentController controller) throws BadLocationException, AuthorOperationException {
        String frag = null;
        int so = node.getStartOffset();
        int eo = node.getEndOffset();
        if (so >= startSelection && so <= endSelection || eo >= startSelection && eo <= endSelection) {
            AuthorDocumentFragment docFrag = null;
            if (so + 1 == eo) {
                docFrag = controller.createNewDocumentTextFragment("");
            } else {
                if (isBlock) {
                    ++so;
                    --eo;
                }
                int fragSO = 0;
                int frageEO = 0;
                fragSO = so >= startSelection && so <= endSelection ? so : startSelection;
                frageEO = eo >= startSelection && eo <= endSelection ? eo : endSelection;
                if (fragSO != 0 && frageEO != 0) {
                    docFrag = controller.createDocumentFragment(fragSO, frageEO);
                }
            }
            if (docFrag != null) {
                frag = controller.serializeFragmentToXML(docFrag);
            }
        }
        return frag;
    }

    @Override
    protected String getParentListType(AuthorNode nodeAtOffset) {
        String parentType = null;
        while (nodeAtOffset != null) {
            if (nodeAtOffset instanceof AuthorElement) {
                String localName = ((AuthorElement)nodeAtOffset).getLocalName();
                if (LIST_ELEMENTS.contains(localName)) {
                    parentType = localName;
                }
                if (parentType != null || LIST_ITEM.equals(localName)) break;
            }
            nodeAtOffset = nodeAtOffset.getParent();
        }
        return parentType;
    }

    @Override
    protected boolean isListElement(AuthorNode node) {
        boolean toRet = false;
        if (node instanceof AuthorElement) {
            String localName = ((AuthorElement)node).getLocalName();
            String parentLocalName = ((AuthorElement)node).getParentElement().getLocalName();
            toRet = LIST_ELEMENTS.contains(localName) || LIST_ITEM_ELEMENTS.contains(localName) || LIST_ELEMENTS.contains(parentLocalName) || LIST_ITEM_ELEMENTS.contains(parentLocalName);
        }
        return toRet;
    }

    @Override
    protected boolean isList(AuthorNode node) {
        boolean toRet = false;
        if (node instanceof AuthorElement) {
            String localName = ((AuthorElement)node).getLocalName();
            toRet = LIST_ELEMENTS.contains(localName);
        }
        return toRet;
    }

    @Override
    protected String getListTypeDescription(String listType) {
        String toRet = "";
        if (ORDERED_LIST.equals(listType)) {
            toRet = "ordered";
        } else if (ITEMIZED_LIST.equals(listType)) {
            toRet = "itemized";
        } else if (VARIABLE_LIST.equals(listType)) {
            toRet = "variable";
        } else if (PROCEDURE.equals(listType)) {
            toRet = PROCEDURE;
        }
        return toRet;
    }
}

