/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteColumnArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteRowArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteRowsArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableInsertColumnArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableOperationsHandler;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSTableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.cals.InsertRowOperation;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.DeleteColumnOperation;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.DeleteRowOperation;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.InsertColumnOperation;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;
import ro.sync.ecss.extensions.docbook.table.InsertTableOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DocbookAuthorTableOperationsHandler
extends AuthorTableOperationsHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)DocbookAuthorTableOperationsHandler.class.getName());
    private ro.sync.ecss.extensions.commons.table.operations.cals.InsertColumnOperation insertCALSColumnOperation = null;
    private InsertColumnOperation insertXHTMLColumnOperation = null;
    private ro.sync.ecss.extensions.commons.table.operations.xhtml.InsertRowOperation insertXHTMLRowOperation = null;
    private InsertRowOperation insertCALSRowOperation = null;
    private InsertTableOperation insertTableOperation = null;
    private DeleteColumnOperation deleteXHTMLColumnOperation = null;
    private ro.sync.ecss.extensions.commons.table.operations.cals.DeleteColumnOperation deleteCALSColumnOperation = null;
    private DeleteRowOperation deleteXHTMLRowOperation = null;
    private ro.sync.ecss.extensions.commons.table.operations.cals.DeleteRowOperation deleteCALSRowOperation = null;
    private final String namespace;

    public DocbookAuthorTableOperationsHandler(String namespace) {
        this.namespace = namespace;
    }

    public boolean handleInsertColumn(AuthorTableInsertColumnArguments tablePasteColumnArgs) throws AuthorOperationException {
        boolean handled = false;
        try {
            AuthorAccess authorAccess = tablePasteColumnArgs.getAuthorAccess();
            boolean isXHTMLTable = false;
            for (AuthorNode currentNode = authorAccess.getDocumentController().getNodeAtOffset(tablePasteColumnArgs.getInsertOffset()); currentNode != authorAccess.getDocumentController().getAuthorDocumentNode() && !TableOperationsUtil.nodeHasProperties(currentNode, "table", this.namespace); currentNode = currentNode.getParent()) {
                if (!TableOperationsUtil.nodeHasProperties(currentNode, "tr", this.namespace)) continue;
                isXHTMLTable = true;
                break;
            }
            if (this.insertTableOperation == null) {
                this.insertTableOperation = new InsertTableOperation();
            }
            if (isXHTMLTable) {
                if (this.insertXHTMLRowOperation == null) {
                    this.insertXHTMLRowOperation = new ro.sync.ecss.extensions.commons.table.operations.xhtml.InsertRowOperation();
                }
                if (this.insertXHTMLColumnOperation == null) {
                    this.insertXHTMLColumnOperation = new InsertColumnOperation();
                }
                this.insertXHTMLColumnOperation.performInsertColumn(authorAccess, this.namespace, tablePasteColumnArgs.getColumnFragments(), tablePasteColumnArgs.getColumnSpecificationInformation(), tablePasteColumnArgs.areFragmentsWrappedInCells(), this.insertXHTMLRowOperation, this.insertTableOperation);
            } else {
                if (this.insertCALSRowOperation == null) {
                    this.insertCALSRowOperation = new InsertRowOperation();
                }
                if (this.insertCALSColumnOperation == null) {
                    this.insertCALSColumnOperation = new ro.sync.ecss.extensions.commons.table.operations.cals.InsertColumnOperation();
                }
                this.insertCALSColumnOperation.performInsertColumn(authorAccess, this.namespace, tablePasteColumnArgs.getColumnFragments(), tablePasteColumnArgs.getColumnSpecificationInformation(), tablePasteColumnArgs.areFragmentsWrappedInCells(), this.insertCALSRowOperation, this.insertTableOperation);
            }
            handled = true;
        }
        catch (IllegalArgumentException | BadLocationException e) {
            logger.warn("Paste column failed.", (Throwable)e);
        }
        return handled;
    }

    public boolean handleDeleteColumn(AuthorTableDeleteColumnArguments arguments) throws AuthorOperationException {
        boolean handled = false;
        AuthorAccess authorAccess = arguments.getAuthorAccess();
        AuthorNode currentNode = null;
        try {
            List intervals = arguments.getColumnCellsIntervals();
            if (intervals != null && !intervals.isEmpty()) {
                int firstCellOffset = ((ContentInterval)intervals.get(0)).getEndOffset();
                currentNode = authorAccess.getDocumentController().getNodeAtOffset(firstCellOffset);
            }
            if (currentNode != null) {
                boolean isXHTMLTable = false;
                while (currentNode != authorAccess.getDocumentController().getAuthorDocumentNode() && !TableOperationsUtil.nodeHasProperties(currentNode, "table", this.namespace)) {
                    if (TableOperationsUtil.nodeHasProperties(currentNode, "tr", this.namespace)) {
                        isXHTMLTable = true;
                        break;
                    }
                    currentNode = currentNode.getParent();
                }
                if (isXHTMLTable) {
                    if (this.deleteXHTMLColumnOperation == null) {
                        this.deleteXHTMLColumnOperation = new DeleteColumnOperation();
                    }
                    handled = this.deleteXHTMLColumnOperation.performDeleteColumn(authorAccess, arguments.getColumnCellsIntervals(), false);
                } else {
                    if (this.deleteCALSColumnOperation == null) {
                        this.deleteCALSColumnOperation = new ro.sync.ecss.extensions.commons.table.operations.cals.DeleteColumnOperation();
                    }
                    handled = this.deleteCALSColumnOperation.performDeleteColumn(authorAccess, arguments.getColumnCellsIntervals(), false);
                }
            }
        }
        catch (BadLocationException e) {
            logger.warn("Delete selected column failed", (Throwable)e);
        }
        return handled;
    }

    @Deprecated
    public boolean handleDeleteRow(AuthorTableDeleteRowArguments arguments) throws AuthorOperationException {
        ArrayList<ContentInterval> contentIntervals = new ArrayList<ContentInterval>(1);
        contentIntervals.add(arguments.getRowInterval());
        return this.handleDeleteRows(arguments.getAuthorAccess(), contentIntervals);
    }

    public boolean handleDeleteRows(AuthorTableDeleteRowsArguments arguments) throws AuthorOperationException {
        return this.handleDeleteRows(arguments.getAuthorAccess(), arguments.getContentIntervals());
    }

    private boolean handleDeleteRows(AuthorAccess authorAccess, List<ContentInterval> contentIntervals) throws AuthorOperationException {
        boolean handled;
        block7: {
            handled = false;
            try {
                if (authorAccess != null && contentIntervals != null && !contentIntervals.isEmpty()) {
                    boolean isXHTMLTable = this.containXhtmlTable(authorAccess, contentIntervals);
                    if (isXHTMLTable) {
                        if (this.deleteXHTMLRowOperation == null) {
                            this.deleteXHTMLRowOperation = new DeleteRowOperation();
                        }
                        handled = this.deleteXHTMLRowOperation.performDeleteRows(authorAccess, contentIntervals);
                    } else {
                        if (this.deleteCALSRowOperation == null) {
                            this.deleteCALSRowOperation = new ro.sync.ecss.extensions.commons.table.operations.cals.DeleteRowOperation();
                        }
                        handled = this.deleteCALSRowOperation.performDeleteRows(authorAccess, contentIntervals);
                    }
                    break block7;
                }
                throw new AuthorOperationException("The operation cannot be performed due to: wrong row content interval argument");
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
            }
        }
        return handled;
    }

    private boolean containXhtmlTable(AuthorAccess authorAccess, List<ContentInterval> contentIntervals) throws BadLocationException {
        boolean isXHTMLTable = false;
        block0: for (ContentInterval contentInterval : contentIntervals) {
            int start = contentInterval.getStartOffset();
            int end = contentInterval.getEndOffset();
            boolean typeWasFound = false;
            for (int i = start; i < end; ++i) {
                OffsetInformation info = authorAccess.getDocumentController().getContentInformationAtOffset(i);
                AuthorNode nodeForMarkerOffset = info.getNodeForMarkerOffset();
                if (nodeForMarkerOffset == null) continue;
                if (TableOperationsUtil.nodeHasProperties(nodeForMarkerOffset, "tr", this.namespace)) {
                    isXHTMLTable = true;
                    typeWasFound = true;
                } else if (TableOperationsUtil.nodeHasProperties(nodeForMarkerOffset, "row", this.namespace)) {
                    isXHTMLTable = false;
                    typeWasFound = true;
                }
                if (typeWasFound) continue block0;
            }
        }
        return isXHTMLTable;
    }

    public AuthorElement getTableElementContainingOffset(AuthorAccess access, int offset) {
        String[] xhtmlTableElementNames = XHTMLDocumentTypeHelper.TABLE_ELEMENT_NAMES;
        String[] tableElementNames = Arrays.copyOf(xhtmlTableElementNames, xhtmlTableElementNames.length + 1);
        tableElementNames[tableElementNames.length - 1] = "table";
        return TableOperationsUtil.getTableElementContainingOffset(offset, this.namespace, access, tableElementNames);
    }

    public TableColumnSpecificationInformation getColumnSpecification(AuthorAccess access, AuthorElement tableElement, int columnIndex) {
        CALSTableColumnSpecificationInformation colspecInfo = null;
        if (tableElement != null) {
            CALSColSpec colSpec;
            CALSTableCellInfoProvider cellInfoProvider = new CALSTableCellInfoProvider();
            cellInfoProvider.init(tableElement);
            Set<CALSColSpec> colSpecs = cellInfoProvider.getColSpecs();
            if (colSpecs.size() > columnIndex && (colSpec = colSpecs.toArray(new CALSColSpec[0])[columnIndex]) != null) {
                colspecInfo = new CALSTableColumnSpecificationInformation(colSpec.getColWidth(), colSpec.getColumnName());
            }
        }
        return colspecInfo;
    }

    public void handleRemoveInvalidColNamesFromTableCells(AuthorAccess authorAccess, AuthorElement tableElement, List<AuthorElement> cells) {
        if (tableElement != null) {
            TableOperationsUtil.removeInvalidColNamesFromCALSTableCells(authorAccess, tableElement, cells);
        }
    }

    public boolean handleAttributeChange(AuthorAccess authorAccess, AuthorElement currentElement, String attributeName, AttrValue newValue) {
        return TableOperationsUtil.handleColumnSpecAttributeChange(authorAccess, new CALSDocumentTypeHelper(), currentElement, attributeName, newValue);
    }
}

