/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.docbook.DocBookImageInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ReferenceType;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.ImageFileChooser;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.docbook.Docbook5InsertMediaDataOperation;
import ro.sync.ecss.extensions.docbook.InsertImageDataOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class Docbook5ExternalObjectInsertionHandler
extends AuthorExternalObjectInsertionHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)Docbook5ExternalObjectInsertionHandler.class.getName());

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, List<ReferenceType> types, int source) throws AuthorOperationException {
        if (!urls.isEmpty()) {
            URL base = Docbook5ExternalObjectInsertionHandler.getBaseURLAtCaretPosition((AuthorAccess)authorAccess);
            for (int i = 0; i < urls.size(); ++i) {
                Integer off;
                URL url = urls.get(i);
                ReferenceType type = types.get(i);
                String relativeLocation = authorAccess.getUtilAccess().makeRelative(base, url);
                SchemaAwareHandlerResult result = null;
                int cp = authorAccess.getEditorAccess().getCaretOffset();
                if (Docbook5ExternalObjectInsertionHandler.isImageReference(authorAccess, type, url)) {
                    DocBookImageInfo imageInfo = new DocBookImageInfo();
                    imageInfo.addProperty("href", ImageFileChooser.makeUrlRelative(authorAccess, relativeLocation));
                    boolean isInlineMediaObjectAccepted = false;
                    try {
                        isInlineMediaObjectAccepted = CommonsOperationsUtil.isAllowedElement("inlinemediaobject", authorAccess.getEditorAccess().getCaretOffset(), authorAccess.getDocumentController().getAuthorSchemaManager());
                    }
                    catch (BadLocationException e) {
                        logger.warn((Object)e, (Throwable)e);
                    }
                    result = InsertImageDataOperation.insertImageRef(authorAccess, imageInfo, isInlineMediaObjectAccepted);
                } else {
                    result = MediaObjectsUtil.isMediaReference(url) ? new Docbook5InsertMediaDataOperation().insertMediaRef(authorAccess, relativeLocation) : authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<link xmlns=\"http://docbook.org/ns/docbook\" xlink:href=\"" + authorAccess.getXMLUtilAccess().escapeAttributeValue(relativeLocation) + "\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"/>", cp, true);
                }
                if (result == null || i >= urls.size() - 1 || (off = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) == null) continue;
                try {
                    AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(off + 1);
                    authorAccess.getEditorAccess().setCaretPosition(nodeAtOffset.getEndOffset() + 1);
                    continue;
                }
                catch (BadLocationException e) {
                    logger.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static boolean isImageReference(AuthorAccess authorAccess, ReferenceType type, URL url) {
        return type == ReferenceType.IMAGE_REFERENCE || type == null && authorAccess.getUtilAccess().isSupportedImageURL(url);
    }

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, int source) throws AuthorOperationException {
        List<Object> types = Collections.nCopies(urls.size(), null);
        this.insertURLs(authorAccess, urls, types, source);
    }

    protected String getImporterStylesheetFileName(AuthorAccess authorAccess) {
        return "xhtml2db5Driver.xsl";
    }
}

