/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ToggleCommentOperation
implements AuthorOperation {
    public String getDescription() {
        return "Wrap selection in an XML comment or unwrap existing XML comment";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        block3: {
            int selStart = authorAccess.getEditorAccess().getSelectionStart();
            try {
                AuthorNode contextNode = authorAccess.getDocumentController().getNodeAtOffset(selStart);
                if (contextNode == null) break block3;
                int selEnd = authorAccess.getEditorAccess().getSelectionEnd();
                if (CommonAccess.isToggleCommentPossibleOnSelection((AuthorAccess)authorAccess, (int)selStart, (int)selEnd)) {
                    CommonAccess.toggleComment((AuthorAccess)authorAccess, (AuthorNode)contextNode, (int)selStart, (int)selEnd);
                    break block3;
                }
                throw new AuthorOperationException("Toggle comment is not possible at this location.");
            }
            catch (BadLocationException ex) {
                throw new AuthorOperationException("Cannot identify the current element", (Throwable)ex);
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[0];
    }
}

