/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.exml.workspace.api.editor.validation.OperationInProgressException;
import ro.sync.exml.workspace.api.editor.validation.ValidationScenarioNotFoundException;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteValidationScenariosOperation
implements AuthorOperation {
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];
    private static final String SCENARIO_NAMES = "scenarioNames";

    public ExecuteValidationScenariosOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(SCENARIO_NAMES, 0, "The names of the validation scenario which will be executed, separated by new lines.");
    }

    public String getDescription() {
        return "Run a named validation scenario defined in the associated document type.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object scenarioNames = args.getArgumentValue(SCENARIO_NAMES);
        if (scenarioNames != null) {
            String names = (String)scenarioNames;
            try {
                String[] allNames = names.split("\n");
                for (int i = 0; i < allNames.length; ++i) {
                    allNames[i] = allNames[i].trim();
                }
                authorAccess.getEditorAccess().runValidationScenarios(allNames);
            }
            catch (IllegalArgumentException | UnsupportedOperationException | OperationInProgressException | ValidationScenarioNotFoundException e) {
                throw new AuthorOperationException(e.getMessage(), e);
            }
        } else {
            throw new AuthorOperationException("The scenario name was not specified as a parameter.");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

