/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.File;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.exml.workspace.api.process.ProcessController;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteCommandLineOperation
implements AuthorOperation {
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    private static final String NAME = "name";
    private static final String WORKING_DIRECTORY = "workingDirectory";
    private static final String CMD_LINE = "cmdLine";
    private static final String SHOW_CONSOLE = "showConsole";
    private static final String WAIT = "wait";
    private static final ArgumentDescriptor NAME_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("name", 0, "The name of the operation. It will also be used as the name of the console.", "Command Line Operation");
    private static final ArgumentDescriptor WORKING_DIRECTORY_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("workingDirectory", 0, "The path to the working directory where the command line will be executed.", ".");
    private static final ArgumentDescriptor CMD_LINE_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("cmdLine", 0, "The command line to be executed. It can contain oXygen editor variables. IMPORTANT: This operation is meant for executing programs. Not any string that a command line interpreter (or shell) accepts can be run by this operation.For example, the \"dir\" command line from Windows is not accepted as it is. The accepted form is \"cmd /c dir\".");
    private static final ArgumentDescriptor SHOW_CONSOLE_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("showConsole", 3, "True to show the console when running the command line.", new String[]{"true", "false"}, "false");
    private static final ArgumentDescriptor WAIT_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("wait", 3, "True to wait until the command terminates to return.", new String[]{"true", "false"}, "false");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{NAME_ARGUMENT_DESCRIPTOR, WORKING_DIRECTORY_ARGUMENT_DESCRIPTOR, CMD_LINE_ARGUMENT_DESCRIPTOR, SHOW_CONSOLE_ARGUMENT_DESCRIPTOR, WAIT_ARGUMENT_DESCRIPTOR};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        String name = (String)args.getArgumentValue(NAME);
        File workingDir = new File((String)args.getArgumentValue(WORKING_DIRECTORY));
        String cmdLine = (String)args.getArgumentValue(CMD_LINE);
        boolean showCmd = TRUE_STRING.equals(args.getArgumentValue(SHOW_CONSOLE));
        boolean wait = TRUE_STRING.equals(args.getArgumentValue(WAIT));
        if (wait) {
            ProcessController processController = authorAccess.getWorkspaceAccess().createProcess(null, name, workingDir, cmdLine, showCmd);
            processController.start();
        } else {
            authorAccess.getWorkspaceAccess().startProcess(name, workingDir, cmdLine, showCmd);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Author operation allowing the execution of command lines.";
    }
}

