/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.editor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.AuthorUtilAccess;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.exml.view.graphics.Color;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class URLChooserEditorSWT
extends AbstractInplaceEditor
implements ITextOperationTarget {
    private Composite urlChooserComposite;
    private Button browseButton;
    private SourceViewer textViewer;
    private Image buttonImage;
    private boolean isBrowsing = false;
    private AuthorUtilAccess utilAccess;
    private org.eclipse.swt.graphics.Font swtFont;
    private org.eclipse.swt.graphics.Color foregroundColor;

    public String getDescription() {
        return "A sample implementation that provides a browse button associated with a text field.";
    }

    public Object getEditorComponent(final AuthorInplaceContext context, Rectangle allocation, Point mouseInvocationLocation) {
        this.prepareComponents(context);
        final AuthorAccess authorAccess = context.getAuthorAccess();
        final URL editorLocation = authorAccess.getEditorAccess().getEditorLocation();
        this.browseButton.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event e) {
                block5: {
                    URLChooserEditorSWT.this.isBrowsing = true;
                    try {
                        URL chooseURL = context.getAuthorAccess().getWorkspaceAccess().chooseURL("Choose URL", null, null);
                        if (chooseURL == null) break block5;
                        String relativeURL = context.getAuthorAccess().getUtilAccess().makeRelative(editorLocation, chooseURL);
                        URLChooserEditorSWT.this.utilAccess = authorAccess.getUtilAccess();
                        try {
                            URL clearedURL = URLChooserEditorSWT.this.utilAccess.removeUserCredentials(new URL(relativeURL));
                            URLChooserEditorSWT.this.textViewer.getTextWidget().setText(clearedURL.toExternalForm());
                        }
                        catch (MalformedURLException e1) {
                            URLChooserEditorSWT.this.textViewer.getTextWidget().setText(relativeURL);
                        }
                        URLChooserEditorSWT.this.fireCommitValue(new EditingEvent((String)URLChooserEditorSWT.this.getValue()));
                    }
                    finally {
                        URLChooserEditorSWT.this.isBrowsing = false;
                    }
                }
            }
        });
        this.browseButton.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    URLChooserEditorSWT.this.fireNextEditLocationRequested();
                    e.doit = false;
                }
            }
        });
        this.textViewer.getTextWidget().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    URLChooserEditorSWT.this.firePreviousEditLocationRequested();
                    e.doit = false;
                }
            }
        });
        this.textViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                switch (event.keyCode) {
                    case 9: {
                        event.doit = false;
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 0x1000050: {
                        if ((event.stateMask & 0x40000) != 0) break;
                        event.doit = false;
                        URLChooserEditorSWT.this.stopEditing(true);
                    }
                }
            }
        });
        return this.urlChooserComposite;
    }

    public Rectangle getScrollRectangle() {
        return null;
    }

    public void requestFocus() {
        this.textViewer.getTextWidget().setFocus();
    }

    public Object getValue() {
        String text = this.textViewer.getTextWidget().getText();
        try {
            URL clearedURL = this.utilAccess.removeUserCredentials(new URL(text));
            return clearedURL.toExternalForm();
        }
        catch (MalformedURLException e) {
            return text;
        }
    }

    public void stopEditing() {
        this.stopEditing(false);
    }

    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    private void stopEditing(boolean onEnter) {
        String text = (String)this.getValue();
        if (onEnter) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent(text));
        }
        this.dispose();
    }

    public void cancelEditing() {
        this.fireEditingCanceled();
        this.dispose();
    }

    private void prepareComponents(AuthorInplaceContext context) {
        this.dispose();
        this.urlChooserComposite = new Composite((Composite)context.getParentHost(), 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.urlChooserComposite.setLayout((Layout)gridLayout);
        this.textViewer = new SourceViewer(this.urlChooserComposite, null, 2052);
        this.textViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsPlugin.getDefault().getPreferenceStore()));
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        this.textViewer.getTextWidget().setLayoutData((Object)gd);
        this.browseButton = new Button(this.urlChooserComposite, 8);
        gd = new GridData(0, 4, false, true);
        this.textViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if (e.keyCode == 27) {
                    e.doit = false;
                    URLChooserEditorSWT.this.cancelEditing();
                }
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(URLChooserEditorSWT.this.urlChooserComposite.isDisposed() || URLChooserEditorSWT.this.browseButton.isFocusControl() || URLChooserEditorSWT.this.textViewer.getTextWidget().isFocusControl() || URLChooserEditorSWT.this.isBrowsing)) {
                            URLChooserEditorSWT.this.fireCommitValue(new EditingEvent((String)URLChooserEditorSWT.this.getValue()));
                        }
                    }
                });
            }
        };
        this.textViewer.getTextWidget().addFocusListener((FocusListener)focusListener);
        this.browseButton.addFocusListener((FocusListener)focusListener);
        this.browseButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    e.doit = false;
                    URLChooserEditorSWT.this.cancelEditing();
                }
            }
        });
        this.textViewer.setDocument((IDocument)new Document(""));
        IDocumentListener docChangedListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                URLChooserEditorSWT.this.fireEditingOccured();
            }
        };
        this.textViewer.getDocument().addDocumentListener(docChangedListener);
        Font font = (Font)context.getArguments().get("font");
        if (font != null) {
            this.swtFont = new org.eclipse.swt.graphics.Font((Device)Display.getDefault(), new FontData(font.getName(), font.getSize(), font.getStyle()));
        }
        if (this.swtFont != null) {
            this.textViewer.getTextWidget().setFont(this.swtFont);
        } else {
            this.textViewer.getTextWidget().setFont(JFaceResources.getDialogFont());
        }
        Color color = (Color)context.getArguments().get("color");
        if (color != null) {
            this.foregroundColor = new org.eclipse.swt.graphics.Color((Device)Display.getDefault(), color.getRed(), color.getGreen(), color.getBlue());
            this.textViewer.getTextWidget().setForeground(this.foregroundColor);
        }
        InputStream resourceAsStream = URLChooserEditorSWT.class.getResourceAsStream("/images/Open16.gif");
        ImageData imageResource = null;
        if (resourceAsStream != null) {
            imageResource = new ImageData(resourceAsStream);
            try {
                resourceAsStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ImageDescriptor icon = null;
        if (imageResource != null) {
            icon = ImageDescriptor.createFromImageData((ImageData)imageResource);
        }
        this.buttonImage = null;
        if (icon != null) {
            this.buttonImage = icon.createImage();
        }
        if (this.buttonImage != null) {
            this.browseButton.setImage(this.buttonImage);
        }
        this.browseButton.setLayoutData((Object)gd);
        this.setInitialValue(context);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (URLChooserEditorSWT.this.textViewer.getTextWidget() != null) {
                    URLChooserEditorSWT.this.textViewer.getTextWidget().showSelection();
                }
            }
        });
        this.textViewer.getUndoManager().reset();
    }

    private void setInitialValue(AuthorInplaceContext context) {
        String text = (String)context.getArguments().get("initial_value");
        if (text == null) {
            text = (String)context.getArguments().get("default_value");
        }
        if (text == null) {
            text = "";
        }
        this.utilAccess = context.getAuthorAccess().getUtilAccess();
        try {
            URL clearedURL = this.utilAccess.removeUserCredentials(new URL(text));
            text = clearedURL.toExternalForm();
            this.textViewer.getTextWidget().setText(text);
        }
        catch (MalformedURLException e1) {
            this.textViewer.getTextWidget().setText(text);
        }
        this.textViewer.getTextWidget().setCaretOffset(text.length());
    }

    private void dispose() {
        if (this.swtFont != null) {
            this.swtFont.dispose();
        }
        if (this.urlChooserComposite != null) {
            this.urlChooserComposite.dispose();
        }
        if (this.buttonImage != null) {
            this.buttonImage.dispose();
        }
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
    }

    public boolean canDoOperation(int operation) {
        return this.textViewer != null && this.textViewer.canDoOperation(operation);
    }

    public void doOperation(int operation) {
        this.textViewer.doOperation(operation);
    }

    public void refresh(AuthorInplaceContext context) {
        this.setInitialValue(context);
    }
}

