/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.JFXPlatformInitializer;
import ro.sync.jfx.JFXPlatformStatus;
import ro.sync.jfx.JavaFXPlatformStatusProvider;
import ro.sync.jfx.RetinaInfo;
import ro.sync.jfx.media.player.JFXMediaPlayerIcons;

public final class JFXUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JFXUtil.class.getName());
    private static RetinaInfo retinaInfo = new RetinaInfo(0, 1.0);

    private JFXUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Scene createErrorScene(String errorMessage) {
        Pane pane = new Pane();
        HBox errorBox = JFXUtil.createErrorBox(errorMessage, "/images/Embed_Failed.png");
        pane.getChildren().add((Object)errorBox);
        return new Scene((Parent)pane);
    }

    public static HBox createErrorBox(String errorMessage, String imagePath) {
        Label label = new Label(errorMessage);
        label.setWrapText(true);
        label.setTooltip(new Tooltip(errorMessage));
        HBox errorBox = new HBox(12.0);
        errorBox.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        errorBox.setAlignment(Pos.CENTER);
        errorBox.getChildren().add((Object)new ImageView(JFXMediaPlayerIcons.getImage(imagePath)));
        errorBox.getChildren().add((Object)label);
        return errorBox;
    }

    public static RetinaInfo getRetinaInfo() {
        return retinaInfo;
    }

    public static void setRetinaInfo(RetinaInfo retinaInfo) {
        JFXUtil.retinaInfo = retinaInfo;
    }

    public static void runLater(Runnable r) {
        Platform.runLater((Runnable)r);
    }

    public static void runNowOrLater(Runnable r) {
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    public static void preloadJavaFx() {
        try {
            JFXPlatformInitializer.lazyInitJFXIfAvailableAndNotInitialized();
            JFXPanel jfxPanel = new JFXPanel();
            LOGGER.debug("Java FX preloaded succesfully...creating dummy object: {}", (Object)jfxPanel);
        }
        catch (Throwable e) {
            JFXPlatformStatus javaFXPlatformStatus = JavaFXPlatformStatusProvider.getJFXPlatformStatus();
            javaFXPlatformStatus.setAvailable(Boolean.FALSE);
            javaFXPlatformStatus.setAdditionalLoadingInfo(e);
            LOGGER.debug("Unable to load and preload Java FX...", e);
        }
    }
}

