/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.privilegedlogs;

import java.util.regex.Pattern;

public final class SensitiveInformationFilterUtil {
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("([Aa]uthorization:) .*");
    private static final Pattern URI_CREDENTIALS_PATTERN = Pattern.compile("://[a-zA-Z0-9-._~%!$&'()*+,;=:]+@");

    private SensitiveInformationFilterUtil() {
    }

    public static String maskAll(String format) {
        format = SensitiveInformationFilterUtil.maskAuthorizationHeaders(format);
        format = SensitiveInformationFilterUtil.maskCredentialsFromURIs(format);
        return format;
    }

    public static String maskAuthorizationHeaders(String format) {
        if (format.indexOf("org.apache.http.headers") != -1 || format.indexOf("org.apache.http.wire") != -1) {
            format = AUTHORIZATION_HEADER_PATTERN.matcher(format).replaceAll("$1 ****");
        }
        return format;
    }

    public static String maskCredentialsFromURIs(String format) {
        return URI_CREDENTIALS_PATTERN.matcher(format).replaceAll("://****@");
    }
}

