/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.privilegedlogs;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.status.Status;
import com.oxygenxml.privilegedlogs.SensitiveInformationFilterUtil;
import java.nio.charset.Charset;

public class SecurityFilterEncoder
implements Encoder<ILoggingEvent> {
    private LayoutWrappingEncoder<ILoggingEvent> encoder;

    public SecurityFilterEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = (LayoutWrappingEncoder)encoder;
    }

    public byte[] encode(ILoggingEvent event) {
        Charset charset = this.encoder.getCharset() != null ? this.encoder.getCharset() : Charset.defaultCharset();
        byte[] encodedEventBytes = this.encoder.encode((Object)event);
        String encodedEventString = new String(encodedEventBytes, charset);
        String filteredEvent = SensitiveInformationFilterUtil.maskAll(encodedEventString);
        return filteredEvent.getBytes(charset);
    }

    public void setContext(Context context) {
        this.setContext(context);
    }

    public Context getContext() {
        return this.encoder.getContext();
    }

    public void addStatus(Status status) {
        this.encoder.addStatus(status);
    }

    public void addInfo(String msg) {
        this.encoder.addInfo(msg);
    }

    public void addInfo(String msg, Throwable ex) {
        this.encoder.addInfo(msg, ex);
    }

    public void addWarn(String msg) {
        this.encoder.addWarn(msg);
    }

    public void addWarn(String msg, Throwable ex) {
        this.encoder.addWarn(msg, ex);
    }

    public void addError(String msg) {
        this.encoder.addError(msg);
    }

    public void addError(String msg, Throwable ex) {
        this.encoder.addError(msg, ex);
    }

    public void start() {
        this.encoder.start();
    }

    public void stop() {
        this.encoder.stop();
    }

    public boolean isStarted() {
        return this.encoder.isStarted();
    }

    public byte[] headerBytes() {
        return this.encoder.headerBytes();
    }

    public byte[] footerBytes() {
        return this.encoder.footerBytes();
    }
}

