/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.privilegedlogs;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class ReadLogFileUtil {
    private static final String OXYGEN_LOGS_FILE = "oxygen.logs.file";

    public static FileInputStream getInputStream() throws IOException {
        FileInputStream result;
        final String filePath = System.getProperty(OXYGEN_LOGS_FILE);
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(filePath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
        return result;
    }

    public static String getLogFileName() {
        String logFileName = System.getProperty(OXYGEN_LOGS_FILE);
        return logFileName.substring(logFileName.lastIndexOf(92) + 1);
    }
}

