/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.privilegedlogs;

import com.oxygenxml.privilegedlogs.LogbackUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrivilegedPropertyConfigurator {
    private static final String LOGGING_LEVEL_SYSTEM_PROPERTY_PREFIX = "logging.level.";

    private PrivilegedPropertyConfigurator() {
    }

    @Deprecated
    public static void configure(String logFile, File logbackigurationFile) {
        PrivilegedPropertyConfigurator.configure(logFile, logbackigurationFile, null);
    }

    public static void configure(String logFile, File logbackigurationFile, File legacyLog4j1PropertiesFile) {
        try {
            PrivilegedPropertyConfigurator.configureLogging(logFile, logbackigurationFile);
            if (legacyLog4j1PropertiesFile != null && legacyLog4j1PropertiesFile.exists()) {
                PrivilegedPropertyConfigurator.readLevelsFromOldFormat(legacyLog4j1PropertiesFile);
            }
            PrivilegedPropertyConfigurator.readLevelsFromSystemProperties();
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void readLevelsFromSystemProperties() {
        System.getProperties().entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(LOGGING_LEVEL_SYSTEM_PROPERTY_PREFIX)).forEach(entry -> {
            String category = entry.getKey().toString().substring(LOGGING_LEVEL_SYSTEM_PROPERTY_PREFIX.length());
            LogbackUtil.setLoggerLevel(category, entry.getValue().toString());
        });
    }

    private static void configureLogging(final String logFile, final File loggingConfigurationFile) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    try {
                        LogbackUtil.setConfigurationFile(logFile, loggingConfigurationFile);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to initialize logging! Invalid logging configuration in " + loggingConfigurationFile);
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readLevelsFromOldFormat(File customLevelsFile) {
        Logger logger = LoggerFactory.getLogger(PrivilegedPropertyConfigurator.class);
        InputStream fis = null;
        try {
            fis = Files.newInputStream(customLevelsFile.toPath(), new OpenOption[0]);
            Properties properties = new Properties();
            properties.load(fis);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = k.toString();
                String value = v.toString();
                if (key.startsWith("log4j.category.")) {
                    String loggerName = key.substring("log4j.category.".length());
                    String levelName = value.trim();
                    LogbackUtil.setLoggerLevel(loggerName, levelName);
                } else if (!key.trim().isEmpty() && key.trim().charAt(0) != '#') {
                    logger.warn("Only log level is used from log4j.properties file via \"log4j.category\". Any other configuration must be added in logback.xml!");
                }
            }));
        }
        catch (IOException e) {
            try {
                logger.warn("Failed to read log4j.properties file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                PrivilegedPropertyConfigurator.closeSilently(fis);
                throw throwable;
            }
            PrivilegedPropertyConfigurator.closeSilently(fis);
        }
        PrivilegedPropertyConfigurator.closeSilently(fis);
    }

    private static void closeSilently(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

