/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.charpicker;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.Cookie;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;

public class SpecialCharServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(SpecialCharServlet.class);
    private static int maxResults = 500;
    private static int scoreFullMatch = 300;
    private static int scorePartialMatch = 150;
    private Map<String, Properties> charsMap = new HashMap<String, Properties>();
    private static final List<String> supportedLanguages = Arrays.asList("en", "fr", "de", "ja", "nl");

    public void init() throws ServletException {
        for (String lang : supportedLanguages) {
            InputStream charsInputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(lang + "_unicodechars.properties");
            if (charsInputStream == null) continue;
            Properties newProps = new Properties();
            try {
                newProps.load(charsInputStream);
            }
            catch (IOException e) {
                log.error("could not load the special character file");
            }
            this.charsMap.put(lang, newProps);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String query = req.getParameter("q");
        resp.setContentType("application/json");
        Map<Object, Object> charResult = new LinkedHashMap();
        if (query.length() == 0) {
            new ObjectMapper().writeValue((OutputStream)resp.getOutputStream(), charResult);
        } else {
            charResult = this.findCharByNameWithCookieLang(query, SpecialCharServlet.getCookieLanguage(req.getCookies()));
            new ObjectMapper().writeValue((OutputStream)resp.getOutputStream(), charResult);
        }
    }

    Map<String, String> findCharByNameWithCookieLang(String query, String cookieLanguage) {
        Properties englishChars;
        Map<String, String> charResult = new LinkedHashMap<String, String>();
        if (cookieLanguage != null && this.charsMap.get(cookieLanguage) != null) {
            charResult = this.findCharByName(query, this.charsMap.get(cookieLanguage));
        }
        if ((englishChars = this.charsMap.get("en")) != null) {
            Map<String, String> englishResults = this.findCharByName(query, englishChars);
            englishResults.putAll(charResult);
            charResult = englishResults;
        }
        return charResult;
    }

    protected static String getCookieLanguage(Cookie[] cookies) {
        String prefix = null;
        if (cookies != null && cookies.length != 0) {
            for (Cookie cookie : cookies) {
                if (!"oxy_lang".equals(cookie.getName())) continue;
                String cookieLanguage = cookie.getValue();
                String cookieLanguagePrefix = cookieLanguage.substring(0, 2);
                if (supportedLanguages.indexOf(cookieLanguage) != -1) {
                    prefix = cookieLanguage;
                    continue;
                }
                if (supportedLanguages.indexOf(cookieLanguagePrefix) == -1) continue;
                prefix = cookieLanguagePrefix;
            }
        }
        return prefix;
    }

    public Map<String, String> findCharByName(String query, Properties chars) {
        query = query.replaceAll("\\s+", " ");
        query = query.replaceAll("[+.^:,*{}\\(\\)\\[\\]]", "");
        String[] queryWords = query.split("\\s+");
        int maxScore = queryWords.length * scoreFullMatch;
        int relevanceThreshold = this.getRelevanceThreshold(queryWords.length);
        Map<String, String> charsFromProperties = this.propsAsMap(chars);
        LinkedHashMap<String, String> matches = new LinkedHashMap<String, String>();
        Map<Integer, Set<Map.Entry<String, String>>> charactersByScore = this.getCharactersByScore(queryWords, charsFromProperties);
        int results = 0;
        block0: for (int score = maxScore; score >= relevanceThreshold; --score) {
            if (charactersByScore.get(score) == null) continue;
            for (Map.Entry<String, String> entry : charactersByScore.get(score)) {
                matches.put(entry.getKey(), entry.getValue());
                if (++results < maxResults) continue;
                continue block0;
            }
        }
        return matches;
    }

    private int getRelevanceThreshold(int queryWordsLength) {
        return queryWordsLength * scoreFullMatch / 2 - 50;
    }

    Map<Integer, Set<Map.Entry<String, String>>> getCharactersByScore(String[] queryWords, Map<String, String> charsFromProperties) {
        HashMap<Integer, Set<Map.Entry<String, String>>> charactersByScore = new HashMap<Integer, Set<Map.Entry<String, String>>>();
        ArrayList<Pattern> fullPatterns = this.getFullPatterns(queryWords);
        ArrayList<Pattern> partialPatterns = this.getPartialPatterns(queryWords);
        int relevanceThreshold = this.getRelevanceThreshold(queryWords.length);
        for (Map.Entry<String, String> entry : charsFromProperties.entrySet()) {
            String charDescription = entry.getValue();
            int score = 0;
            for (int i = 0; i < queryWords.length; ++i) {
                Matcher matcher = fullPatterns.get(i).matcher(charDescription);
                if (matcher.find()) {
                    score += scoreFullMatch;
                    charDescription = matcher.replaceAll("");
                    continue;
                }
                matcher = partialPatterns.get(i).matcher(charDescription);
                if (!matcher.find()) continue;
                score += scorePartialMatch;
            }
            if ((score -= entry.getValue().length()) < relevanceThreshold) continue;
            charactersByScore.computeIfAbsent(score, s -> new HashSet()).add(entry);
        }
        return charactersByScore;
    }

    private Map<String, String> propsAsMap(Properties props) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    private ArrayList<Pattern> getFullPatterns(String[] queryWords) {
        ArrayList<Pattern> fullPatterns = new ArrayList<Pattern>();
        for (int i = 0; i < queryWords.length; ++i) {
            Pattern pattern = Pattern.compile("\\b" + queryWords[i] + "\\b", 2);
            fullPatterns.add(pattern);
        }
        return fullPatterns;
    }

    private ArrayList<Pattern> getPartialPatterns(String[] queryWords) {
        ArrayList<Pattern> partialPatterns = new ArrayList<Pattern>();
        for (int i = 0; i < queryWords.length; ++i) {
            Pattern pattern = Pattern.compile("\\b" + queryWords[i] + "[a-zA-Z]+\\b", 2);
            partialPatterns.add(pattern);
        }
        return partialPatterns;
    }

    public String getPath() {
        return "charpicker-plugin";
    }

    public Properties getChars(String lang) {
        return this.charsMap.get(lang);
    }

    public void setChars(String lang, Properties chars) {
        this.charsMap.put(lang, chars);
    }
}

