/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.rest.response.lists;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oxygenxml.webapp.sharepoint.rest.response.lists.SpList;
import com.oxygenxml.webapp.sharepoint.rest.response.lists.SpListItem;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@JsonIgnoreProperties(ignoreUnknown=true)
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GetsListsResult {
    @JsonProperty(value="value")
    private List<SpList> lists;
    @XmlElement(name="entry", namespace="http://www.w3.org/2005/Atom")
    private List<Entry> entries;

    public List<SpList> getLists() {
        if (this.entries == null) {
            return this.lists;
        }
        ArrayList<SpList> listDescriptors = new ArrayList<SpList>(this.entries.size());
        for (Entry entry : this.entries) {
            if (entry.content == null || entry.content.spList == null || entry.links == null) continue;
            for (Link link : entry.links) {
                if (link == null || !"RootFolder".equals(link.linkTitle)) continue;
                SpListItem rootFolder = new SpListItem();
                rootFolder.setServerRelativeUrl(GetsListsResult.extractServerRelativeUrl(link));
                entry.content.spList.setRootFolder(rootFolder);
                break;
            }
            listDescriptors.add(entry.content.spList);
        }
        return listDescriptors;
    }

    private static String extractServerRelativeUrl(Link link) {
        if (link.inline != null && link.inline.inlineEntry != null && link.inline.inlineEntry.inlineEntryContent != null && link.inline.inlineEntry.inlineEntryContent.spListItem != null) {
            return link.inline.inlineEntry.inlineEntryContent.spListItem.getServerRelativeUrl();
        }
        return null;
    }

    public String toString() {
        return new StringBuilder(32).append("GetsListsResult [\n    lists=").append(this.lists).append("\n]").toString();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class Entry {
        @XmlElement(name="link", namespace="http://www.w3.org/2005/Atom")
        List<Link> links;
        @XmlElement(name="content", namespace="http://www.w3.org/2005/Atom")
        Content content;

        private Entry() {
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class Content {
        @XmlElement(name="properties", namespace="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")
        SpList spList;

        private Content() {
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class Link {
        @XmlAttribute(name="title")
        String linkTitle;
        @XmlElement(name="inline", namespace="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")
        Inline inline;

        private Link() {
        }
    }

    private static class Inline {
        @XmlElement(name="entry", namespace="http://www.w3.org/2005/Atom")
        InlineEntry inlineEntry;

        private Inline() {
        }
    }

    private static class InlineEntry {
        @XmlElement(name="content", namespace="http://www.w3.org/2005/Atom")
        InlineEntryContent inlineEntryContent;

        private InlineEntry() {
        }
    }

    private static class InlineEntryContent {
        @XmlElement(name="properties", namespace="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")
        SpListItem spListItem;

        private InlineEntryContent() {
        }
    }
}

