/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.rest;

import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import com.oxygenxml.webapp.sharepoint.rest.RestUrlPattern;
import com.oxygenxml.webapp.sharepoint.rest.XMLRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.response.contextinfo.ContextWebInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import ro.sync.basic.util.URLUtil;

public final class RestUtil {
    private RestUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String getWebUrl(String url, String accessToken) throws IOException {
        String uWithoutQuery = URLUtil.removeQueryOrAnchorFromName((String)url);
        URL contextInfoRestUrl = RestUrlPattern.CONTEXT_INFO.getRestUrl(uWithoutQuery);
        RestURLStreamProvider webContextInfoStreamProvider = new RestURLStreamProvider(contextInfoRestUrl, accessToken);
        XMLRestRequest<ContextWebInfo> contextWebInfoRequest = new XMLRestRequest<ContextWebInfo>(webContextInfoStreamProvider, ContextWebInfo.class);
        ContextWebInfo contextInfo = (ContextWebInfo)contextWebInfoRequest.write(new byte[0]);
        return contextInfo == null ? null : contextInfo.getWebFullUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readIs(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return sb;
    }

    public static String getAbsoluteURLFromServerRelativeURL(String host, String relURL) {
        String pattern = "https://{0}{1}";
        String encodedRelUrl = URLUtil.correct((String)relURL, (boolean)true);
        return MessageFormat.format(pattern, host, encodedRelUrl);
    }
}

