/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;

public enum RestUrlPattern {
    FILE_CONTENT("{0}/_api/web/GetFileByServerRelativeUrl(''{1}'')/$value"),
    GET_FILE_BY_ID("{0}/_api/web/GetFileById(''{1}'')"),
    CHECKED_OUT_BY_USER("{0}/_api/web/GetFileByServerRelativeUrl(''{1}'')/CheckedOutByUser"),
    GET_CURRENT_USER("{0}/_api/web/CurrentUser"),
    CHECK_OUT("{0}/_api/web/GetFileByServerRelativeUrl(''{1}'')/CheckOut()"),
    CHECK_IN("{0}/_api/web/GetFileByServerRelativeUrl(''{1}'')/CheckIn(comment=''{2}'',checkintype={3})"),
    DISCARD_CHECK_OUT("{0}/_api/web/GetFileByServerRelativeUrl(''{1}'')/UndoCheckOut()"),
    NEW_FILE("{0}/_api/web/GetFolderByServerRelativeUrl(''{1}'')/Files/add(url=''{2}'',overwrite=true)"),
    LIST_FOLDERS("{0}/_api/web/GetFolderByServerRelativeUrl(''{1}'')/Folders"),
    LIST_FILES("{0}/_api/web/GetFolderByServerRelativeUrl(''{1}'')/Files"),
    CONTEXT_INFO("{0}/_api/contextinfo"),
    GET_LISTS_INCLUDING_ROOT_FOLDER("{0}/_api/Web/Lists?$filter=Hidden+eq+false&$select=title,id,hidden,RootFolder&$expand=rootfolder"),
    GET_WEBS("{0}/_api/web/webs?$select=description,id,url,sitelogourl,title");

    private String pattern;

    private RestUrlPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public URL getRestUrl(String ... params) throws MalformedURLException {
        String formattedUrl = MessageFormat.format(this.pattern, params);
        return new URL(formattedUrl);
    }
}

