/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.rest;

import com.oxygenxml.webapp.sharepoint.ConnectionClosingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class RestURLStreamProvider {
    private final String accessToken;
    private final URL restURL;
    private final boolean usePut;
    private final Map<String, String> requestProperties = new HashMap<String, String>(0);

    public RestURLStreamProvider(URL restURL, String accessToken) {
        this(restURL, accessToken, true);
    }

    public RestURLStreamProvider(URL restURL, String accessToken, boolean usePut) {
        this.restURL = restURL;
        this.accessToken = accessToken;
        this.usePut = usePut;
    }

    protected HttpURLConnection openConnection() throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)this.restURL.openConnection();
        urlConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
        if (!this.requestProperties.isEmpty()) {
            for (Map.Entry<String, String> property : this.requestProperties.entrySet()) {
                urlConnection.setRequestProperty(property.getKey(), property.getValue());
            }
        }
        return urlConnection;
    }

    public InputStream getInputStream(boolean acceptJson) throws IOException {
        return this.openConnection().getInputStream();
    }

    public void setRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    public OutputStream getOutputStream() throws IOException {
        HttpURLConnection urlConnection = this.openConnectionForWrite();
        return new ConnectionClosingOutputStream(urlConnection);
    }

    public HttpURLConnection openConnectionForWrite() throws IOException, ProtocolException {
        HttpURLConnection urlConnection = this.openConnection();
        urlConnection.setDoOutput(true);
        urlConnection.setRequestMethod(this.usePut ? "PUT" : "POST");
        return urlConnection;
    }
}

