/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.webapp.sharepoint.rest.BaseRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequest<T>
extends BaseRestRequest<T> {
    private static final Logger log = LoggerFactory.getLogger(RestRequest.class);
    private static final HashMap<Class<?>, JAXBContext> JAXB_CONTEXTS = new HashMap();

    public RestRequest(RestURLStreamProvider streamProvider, Class<T> clazz) {
        super(streamProvider, clazz);
    }

    @Override
    protected T parse(InputStream inputStream, String contentType) throws IOException {
        Object result = null;
        ObjectMapper objectMapper = new ObjectMapper();
        if (contentType.contains("application/xml") || contentType.contains("application/atom+xml")) {
            try {
                result = this.unmarshalFromXml(inputStream);
            }
            catch (JAXBException e) {
                log.warn("Xml processing failed", (Throwable)e);
            }
        } else if (contentType.contains("application/json")) {
            if (contentType.contains("verbose")) {
                Map.Entry next;
                JsonNode firstNode;
                String firstNodeText;
                JsonNode tree = objectMapper.readTree(inputStream);
                JsonNode d = tree.get("d");
                Iterator fields = d.fields();
                if (fields.hasNext() && (!"null".equals(firstNodeText = (firstNode = (JsonNode)(next = (Map.Entry)fields.next()).getValue()).asText()) || fields.hasNext())) {
                    result = objectMapper.convertValue((Object)d, this.clazz);
                }
            } else {
                try {
                    result = objectMapper.readValue(inputStream, this.clazz);
                }
                catch (JsonProcessingException e) {
                    log.warn("Json processing failed", (Throwable)e);
                }
            }
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext() throws JAXBException {
        JAXBContext jaxbContext = null;
        HashMap<Class<?>, JAXBContext> hashMap = JAXB_CONTEXTS;
        synchronized (hashMap) {
            JAXBContext jaxbCtx = JAXB_CONTEXTS.get(this.clazz);
            if (jaxbCtx == null) {
                jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{this.clazz});
                JAXB_CONTEXTS.put(this.clazz, jaxbCtx);
            }
            jaxbContext = jaxbCtx;
        }
        return jaxbContext;
    }

    private T unmarshalFromXml(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        return (T)unmarshaller.unmarshal(inputStream);
    }
}

