/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.rest;

import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import ro.sync.basic.io.QuietClosable;

public abstract class BaseRestRequest<T> {
    protected final RestURLStreamProvider streamProvider;
    protected final Class<T> clazz;

    public BaseRestRequest(RestURLStreamProvider streamProvider, Class<T> clazz) {
        this.streamProvider = streamProvider;
        this.clazz = clazz;
    }

    public T get() throws IOException {
        HttpURLConnection urlConnection = this.streamProvider.openConnection();
        String contentType = urlConnection.getHeaderField("Content-Type");
        try (InputStream inputStream = QuietClosable.from((InputStream)urlConnection.getInputStream());){
            T t = this.parse(inputStream, contentType);
            return t;
        }
    }

    public T write(byte[] body) throws IOException {
        HttpURLConnection urlConn = this.streamProvider.openConnectionForWrite();
        try (OutputStream os = urlConn.getOutputStream();){
            if (body != null) {
                os.write(body);
            }
        }
        String contentType = urlConn.getHeaderField("Content-Type");
        try (InputStream inputStream = QuietClosable.from((InputStream)urlConn.getInputStream());){
            T t = this.parse(inputStream, contentType);
            return t;
        }
    }

    protected abstract T parse(InputStream var1, String var2) throws IOException;
}

